public class UE6Aufgabe45b {

	public static void main(String[] args) {

		// Initialisierungen
		final int startPunktzahl = 50;

		int ball = 0;
		int[] punkte = new int[2];
		for (int i = 0; i < 2; i++) {
			punkte[i] = startPunktzahl;
		}

		// spielen
		while (!spielende(ball, punkte)) {
			ball = spielrunde(ball, punkte);
		}

		// Siegerehrung
		ausgaben(ball, punkte);
		if (ball < 0) {
			System.out.println("Sieger ist Spieler 2");
		} else if (ball > 0) {
			System.out.println("Sieger ist Spieler 1");
		} else {
			System.out.println("Unentschieden");
		}

	}

	static int spielrunde(int ball, int[] punkte) {

		ausgaben(ball, punkte);

		// Eingaben
		int zahl1 = eingabe(1, punkte[0]);
		int zahl2 = eingabe(2, punkte[1]);

		// Zahlen subtrahieren
		punkte[0] -= zahl1;
		punkte[1] -= zahl2;

		// Vergleich und Spielzug
		if (zahl1 > zahl2) { // Spieler 1 gewinnt die Runde
			ball = ball <= 0 ? 1 : ball + 1;
		} else if (zahl2 > zahl1) { // Spieler 2 gewinnt die Runde
			ball = ball >= 0 ? -1 : ball - 1;
		}

		return ball;
	}

	static int eingabe(int spieler, int punkte) {
		int eingabe = IO.readInt("Spieler " + spieler + "! Zahl (>= 0; <= "
				+ punkte + "): ");
		while (eingabe < 0 || eingabe > punkte) {
			eingabe = IO.readInt("Fehler! Spieler " + spieler
					+ "! Zahl (>= 0; <= " + punkte + "): ");
		}
		return eingabe;
	}

	static boolean spielende(int ball, int[] punkte) {
		return (punkte[0] == 0 && punkte[1] == 0) || Math.abs(ball) == 3;
	}

	static void ausgaben(int ball, int[] punkte) {
		System.out.println("Ball im Feld " + ball);
		System.out.println("Punktzahl Spieler 1 = " + punkte[0]);
		System.out.println("Punktzahl Spieler 2 = " + punkte[1]);
		System.out.println();
	}

}
