// siehe http://de.wikipedia.org/wiki/Bin%C3%A4re_Exponentiation

public class UE6Aufgabe25 {

	public static void main(String[] args) {
		double x = IO.readDouble("x: ");
		int k = IO.readInt("k: ");
		System.out.println(x + " hoch " + k + " = " + binExp(x, k));
	}

	// (1) Umwandlung von k in die zugehrige Binrdarstellung.
	// (2) Ersetzen jeder 0 durch Q und jeder 1 durch QM.
	// (3) Nun wird Q als Anweisung zum Quadrieren von x und M als Anweisung zum
	// Multiplizieren von x aufgefasst.
	// (4) Somit bildet die resultierende Zeichenkette von links nach rechts
	// gelesen eine Vorschrift zur Berechnung von x hoch k. Man beginne mit 1,
	// quadriere fr jedes gelesene Q das bisherige Zwischenergebnis und
	// multipliziere es fr jedes gelesene M mit x.
	static double binExp(double x, int k) {
		double result = 1;
		String instruction = changeToQM(getBinaer(k));
		for (int i=0; i<instruction.length(); i++) {
			if (instruction.charAt(i) == 'Q') {
				result = result * result;
			} else if (instruction.charAt(i) == 'M') {
				result = result * x;
			}
		}
		return result;
	}
	
	static String getBinaer(int zahl) {
		String result = "";
		while (zahl > 0) {
			result = zahl % 2 + result;
			zahl = zahl / 2;
		}
		return result;
	}
	
	static String changeToQM(String str) {
		str = str.replace("0", "Q");
		str = str.replace("1", "QM");
		return str;
	}

}
