package view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;

import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;

import model.Territorium;
import tdd.views.TDDPanel;
import util.ImageLoader;
import util.Resources;
import controller.QuitListener;
import controller.TDDFrameworkContainer;
import controller.program.CompileProgramListener;
import controller.program.CreateProgramListener;
import controller.program.DeleteProgramListener;
import controller.program.OpenProgramListener;
import controller.program.PrintProgramListener;
import controller.program.Program;
import controller.program.ProgramManager;
import controller.program.SaveProgramListener;
import controller.simulation.PauseListener;
import controller.simulation.RunAllTestsListener;
import controller.simulation.RunListener;
import controller.simulation.SimulationManager;
import controller.simulation.SimulationState;
import controller.simulation.SpeedListener;
import controller.simulation.StopListener;
import controller.territory.ChangeSizeListener;
import controller.territory.ClearButtonListener;
import controller.territory.CornButtonListener;
import controller.territory.CursorButtonListener;
import controller.territory.HamsterGibListener;
import controller.territory.HamsterLinksUmListener;
import controller.territory.HamsterNimmListener;
import controller.territory.HamsterVorListener;
import controller.territory.LoadTerritoryListener;
import controller.territory.PrintTerritoryListener;
import controller.territory.SaveTerritoryListener;
import controller.territory.TerritoryManager;
import controller.territory.TerritoryMouseListener;
import controller.territory.WallButtonListener;

public class SimulatorFrame extends JFrame {

	JMenuBar menuBar;

	JMenu programMenu;
	JMenu editorMenu;
	JMenu territoriumMenu;
	JMenu hamsterMenu;
	JMenu simulationMenu;

	JMenuItem openMenuItem;
	JMenuItem createMenuItem;
	JMenuItem deleteMenuItem;
	JMenuItem quitMenuItem;
	
	JMenuItem saveMenuItem;
	OMenuItem compileMenuItem;
	JMenuItem printProgramMenuItem;
	
	OMenuItem loadTerMenu;

	//OMenuItem loadSAXTerMenuItem;
	//OMenuItem loadDOMTerMenuItem;
	//OMenuItem loadStAXCursorTerMenuItem;
	//OMenuItem loadStAXIteratorTerMenuItem;

	JMenuItem saveTerMenuItem;
	//JMenuItem serTerMenuItem;
	//OMenuItem deserTerMenuItem;
	JMenuItem printTerMenuItem;
	OMenuItem sizeTerMenuItem;
	
	OMenuItem forwardMenuItem;
	OMenuItem turnLeftMenuItem;
	OMenuItem takeMenuItem;
	OMenuItem giveMenuItem;

	OMenuItem runMenuItem;
	OMenuItem pauseMenuItem;
	OMenuItem stopMenuItem;

	JToolBar toolBar;

	JButton saveButton;
	OButton compileButton;

	OButton sizeTerButton;
	JToggleButton cursorButton;
	JToggleButton cornButton;
	JToggleButton wallButton;
	JToggleButton clearButton;

	OButton runAllTestsButton;
	OButton runButton;
	OButton pauseButton;
	OButton stopButton;
	JSlider speedSlider;
	
	OButton forwardButton;
	OButton turnLeftButton;
	OButton takeButton;
	OButton giveButton;

	JSplitPane mainPanel;
	Editor editor;
	TerritoriumPanel territoriumPanel;

	JTextArea messagePanel;

	Territorium territorium;
	JTabbedPane tabPane;

	public SimulatorFrame(Territorium terr, Program program) {
		super(Resources.getValue("frame.title") + " - " + program.getDirectory().getName());
		this.territorium = terr;

		this.addWindowListener(new QuitListener());
		this.setLayout(new BorderLayout());

		this.initMenues();
		this.setJMenuBar(this.menuBar);

		this.initToolbar();
		this.add(this.toolBar, BorderLayout.NORTH);

		this.initMainPanel();
		this.add(this.mainPanel, BorderLayout.CENTER);

		this.initMessagePanel();
		this.add(this.messagePanel, BorderLayout.SOUTH);

		this.pack();
		this.editor.requestFocusInWindow();
	}

	void initMenues() {
		this.menuBar = new JMenuBar();
		this.initProgramMenu();
		this.menuBar.add(this.programMenu);
		this.initEditorMenu();
		this.menuBar.add(this.editorMenu);
		this.initTerritoriumMenu();
		this.menuBar.add(this.territoriumMenu);
		this.initHamsterMenu();
		this.menuBar.add(this.hamsterMenu);
		this.initSimulationMenu();
		this.menuBar.add(this.simulationMenu);
	}
	
	void initProgramMenu() {
		
		this.programMenu = new JMenu(Resources.getValue("menu.program.text"));
		this.programMenu.setMnemonic(Resources.getValue("menu.program.mnemonic").charAt(0));
		
		this.openMenuItem = new JMenuItem();
		this.openMenuItem.setText(Resources.getValue("item.open.text"));
		this.openMenuItem.setToolTipText(Resources.getValue("item.open.tooltip"));
		this.openMenuItem.setMnemonic(Resources.getValue("item.open.mnemonic").charAt(0));
		this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.open.accelerator")));
		this.openMenuItem.addActionListener(new OpenProgramListener());
		this.programMenu.add(this.openMenuItem);
		
		this.createMenuItem = new JMenuItem();
		this.createMenuItem.setText(Resources.getValue("item.create.text"));
		this.createMenuItem.setToolTipText(Resources.getValue("item.create.tooltip"));
		this.createMenuItem.setMnemonic(Resources.getValue("item.create.mnemonic").charAt(0));
		this.createMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.create.accelerator")));
		this.createMenuItem.addActionListener(new CreateProgramListener(true));
		this.programMenu.add(this.createMenuItem);
		
		this.deleteMenuItem = new JMenuItem();
		this.deleteMenuItem.setText(Resources.getValue("item.delete.text"));
		this.deleteMenuItem.setToolTipText(Resources.getValue("item.delete.tooltip"));
		this.deleteMenuItem.setMnemonic(Resources.getValue("item.delete.mnemonic").charAt(0));
		this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.delete.accelerator")));
		this.deleteMenuItem.addActionListener(new DeleteProgramListener());
		this.programMenu.add(this.deleteMenuItem);
		
		this.quitMenuItem = new JMenuItem();
		this.quitMenuItem.setText(Resources.getValue("item.quit.text"));
		this.quitMenuItem.setToolTipText(Resources.getValue("item.quit.tooltip"));
		this.quitMenuItem.setMnemonic(Resources.getValue("item.quit.mnemonic").charAt(0));
		this.quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.quit.accelerator")));
		this.quitMenuItem.addActionListener(new QuitListener());
		this.programMenu.add(this.quitMenuItem);
	}

	void initEditorMenu() {
		this.editorMenu = new JMenu(Resources.getValue("menu.editor.text"));
		this.editorMenu.setMnemonic(Resources.getValue("menu.editor.mnemonic")
				.charAt(0));

		this.saveMenuItem = new JMenuItem();
		this.saveMenuItem.setText(Resources.getValue("item.save.text"));
		this.saveMenuItem.setToolTipText(Resources.getValue("item.save.tooltip"));
		this.saveMenuItem.setMnemonic(Resources.getValue("item.save.mnemonic").charAt(0));
		this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.save.accelerator")));
		this.saveMenuItem.addActionListener(new SaveProgramListener());
		this.editorMenu.add(this.saveMenuItem);

		this.compileMenuItem = new OMenuItem(SimulationState.NOT_RUNNING);
		this.compileMenuItem.setText(Resources.getValue("item.compile.text"));
		this.compileMenuItem.setToolTipText(Resources
				.getValue("item.compile.tooltip"));
		this.compileMenuItem.setMnemonic(Resources.getValue(
				"item.compile.mnemonic").charAt(0));
		this.compileMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources
				.getValue("item.compile.accelerator")));
		this.compileMenuItem.addActionListener(new CompileProgramListener());
		SimulationManager.getSimulationManager().addObserver(
				this.compileMenuItem);
		this.editorMenu.add(this.compileMenuItem);

		this.printProgramMenuItem = new JMenuItem();
		this.printProgramMenuItem.setText(Resources
				.getValue("item.printprogram.text"));
		this.printProgramMenuItem.setToolTipText(Resources
				.getValue("item.printprogram.tooltip"));
		this.printProgramMenuItem.setMnemonic(Resources.getValue(
				"item.printprogram.mnemonic").charAt(0));
		this.printProgramMenuItem.setAccelerator(KeyStroke
				.getKeyStroke(Resources
						.getValue("item.printprogram.accelerator")));
		this.printProgramMenuItem.addActionListener(new PrintProgramListener());
		this.editorMenu.add(this.printProgramMenuItem);

		this.editorMenu.addSeparator();
	}

	void initTerritoriumMenu() {
		this.territoriumMenu = new JMenu(
				Resources.getValue("menu.territorium.text"));
		this.territoriumMenu.setMnemonic(Resources.getValue(
				"menu.territorium.mnemonic").charAt(0));

		this.saveTerMenuItem = new JMenuItem();
		this.saveTerMenuItem.setText(Resources.getValue("item.saveter.text"));
		this.saveTerMenuItem.setToolTipText(Resources.getValue("item.saveter.tooltip"));
		this.saveTerMenuItem.setMnemonic(Resources.getValue("item.saveter.mnemonic").charAt(0));
		this.saveTerMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.saveter.accelerator")));
		this.saveTerMenuItem.addActionListener(new SaveTerritoryListener());
		this.territoriumMenu.add(this.saveTerMenuItem);

		this.loadTerMenu = new OMenuItem(SimulationState.NOT_RUNNING);
		this.loadTerMenu.setText(Resources.getValue("menu.loadter.text"));
		this.loadTerMenu.setToolTipText(Resources.getValue("menu.loadter.tooltip"));
		this.loadTerMenu.setMnemonic(Resources.getValue("menu.loadter.mnemonic").charAt(0));
		this.loadTerMenu.addActionListener(new LoadTerritoryListener());
		SimulationManager.getSimulationManager().addObserver(this.loadTerMenu);
		this.territoriumMenu.add(this.loadTerMenu);

		//this.loadSAXTerMenuItem = new OMenuItem(SimulationState.NOT_RUNNING);
		//this.loadSAXTerMenuItem.setText(Resources.getValue("item.loadter.sax.text"));
		//this.loadSAXTerMenuItem.setToolTipText(Resources.getValue("item.loadter.sax.tooltip"));
		//this.loadSAXTerMenuItem.setMnemonic(Resources.getValue("item.loadter.sax.mnemonic").charAt(0));
		//this.loadSAXTerMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.loadter.sax.accelerator")));
		//this.loadSAXTerMenuItem.addActionListener(new LoadSAXTerritoryListener());
		//SimulationManager.getSimulationManager().addObserver(this.loadSAXTerMenuItem);
		//this.loadTerMenu.add(this.loadSAXTerMenuItem);

		//this.loadDOMTerMenuItem = new OMenuItem(SimulationState.NOT_RUNNING);
		//this.loadDOMTerMenuItem.setText(Resources.getValue("item.loadter.dom.text"));
		//this.loadDOMTerMenuItem.setToolTipText(Resources.getValue("item.loadter.dom.tooltip"));
		//this.loadDOMTerMenuItem.setMnemonic(Resources.getValue("item.loadter.dom.mnemonic").charAt(0));
		//this.loadDOMTerMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.loadter.dom.accelerator")));
		//this.loadDOMTerMenuItem.addActionListener(new LoadDOMTerritoryListener());
		//SimulationManager.getSimulationManager().addObserver(this.loadDOMTerMenuItem);
		//this.loadTerMenu.add(this.loadDOMTerMenuItem);

		//this.loadStAXCursorTerMenuItem = new OMenuItem(SimulationState.NOT_RUNNING);
		//this.loadStAXCursorTerMenuItem.setText(Resources.getValue("item.loadter.cursor.text"));
		//this.loadStAXCursorTerMenuItem.setToolTipText(Resources.getValue("item.loadter.cursor.tooltip"));
		//this.loadStAXCursorTerMenuItem.setMnemonic(Resources.getValue("item.loadter.cursor.mnemonic").charAt(0));
		//this.loadStAXCursorTerMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.loadter.cursor.accelerator")));
		//this.loadStAXCursorTerMenuItem.addActionListener(new LoadStAXCursorTerritoryListener());
		//SimulationManager.getSimulationManager().addObserver(this.loadStAXCursorTerMenuItem);
		//this.loadTerMenu.add(this.loadStAXCursorTerMenuItem);

		//this.loadStAXIteratorTerMenuItem = new OMenuItem(SimulationState.NOT_RUNNING);
		//this.loadStAXIteratorTerMenuItem.setText(Resources.getValue("item.loadter.iterator.text"));
		//this.loadStAXIteratorTerMenuItem.setToolTipText(Resources.getValue("item.loadter.iterator.tooltip"));
		//this.loadStAXIteratorTerMenuItem.setMnemonic(Resources.getValue("item.loadter.iterator.mnemonic").charAt(0));
		//this.loadStAXIteratorTerMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.loadter.iterator.accelerator")));
		//this.loadStAXIteratorTerMenuItem.addActionListener(new LoadStAXIteratorTerritoryListener());
		//SimulationManager.getSimulationManager().addObserver(this.loadStAXIteratorTerMenuItem);
		//this.loadTerMenu.add(this.loadStAXIteratorTerMenuItem);

		//this.serTerMenuItem = new JMenuItem();
		//this.serTerMenuItem.setText(Resources.getValue("item.serter.text"));
		//this.serTerMenuItem.setToolTipText(Resources.getValue("item.serter.tooltip"));
		//this.serTerMenuItem.setMnemonic(Resources.getValue("item.serter.mnemonic").charAt(0));
		//this.serTerMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.serter.accelerator")));
		//this.serTerMenuItem.addActionListener(new SerializeTerritoryListener());
		//this.territoriumMenu.add(this.serTerMenuItem);

		//this.deserTerMenuItem = new OMenuItem(SimulationState.NOT_RUNNING);
		//this.deserTerMenuItem.setText(Resources.getValue("item.deserter.text"));
		//this.deserTerMenuItem.setToolTipText(Resources.getValue("item.deserter.tooltip"));
		//this.deserTerMenuItem.setMnemonic(Resources.getValue("item.deserter.mnemonic").charAt(0));
		//this.deserTerMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.deserter.accelerator")));
		//this.deserTerMenuItem.addActionListener(new DeserializeTerritoryListener());
		//SimulationManager.getSimulationManager().addObserver(this.deserTerMenuItem);
		//this.territoriumMenu.add(this.deserTerMenuItem);

		this.printTerMenuItem = new JMenuItem();
		this.printTerMenuItem.setText(Resources.getValue("item.printter.text"));
		this.printTerMenuItem.setToolTipText(Resources
				.getValue("item.printter.tooltip"));
		this.printTerMenuItem.setMnemonic(Resources.getValue(
				"item.printter.mnemonic").charAt(0));
		this.printTerMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources
				.getValue("item.printter.accelerator")));
		this.printTerMenuItem.addActionListener(new PrintTerritoryListener());
		this.territoriumMenu.add(this.printTerMenuItem);

		this.sizeTerMenuItem = new OMenuItem(SimulationState.NOT_RUNNING);
		this.sizeTerMenuItem.setText(Resources.getValue("item.sizeter.text"));
		this.sizeTerMenuItem.setToolTipText(Resources
				.getValue("item.sizeter.tooltip"));
		this.sizeTerMenuItem.setMnemonic(Resources.getValue(
				"item.sizeter.mnemonic").charAt(0));
		this.sizeTerMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources
				.getValue("item.sizeter.accelerator")));
		this.sizeTerMenuItem.addActionListener(new ChangeSizeListener(
				this.sizeTerMenuItem, this.territoriumMenu));
		SimulationManager.getSimulationManager().addObserver(
				this.sizeTerMenuItem);
		this.territoriumMenu.add(this.sizeTerMenuItem);
	}
	
	void initHamsterMenu() {
		
		this.hamsterMenu = new JMenu(Resources.getValue("menu.hamster.text"));
		this.hamsterMenu.setMnemonic(Resources.getValue("menu.hamster.mnemonic").charAt(0));
		
		this.forwardMenuItem = new OMenuItem(SimulationState.NOT_RUNNING);
		this.forwardMenuItem.setText(Resources.getValue("item.forward.text"));
		this.forwardMenuItem.setToolTipText(Resources.getValue("item.forward.tooltip"));
		this.forwardMenuItem.setMnemonic(Resources.getValue("item.forward.mnemonic").charAt(0));
		this.forwardMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.forward.accelerator")));
		this.forwardMenuItem.setEnabled(true);
		this.forwardMenuItem.addActionListener(new HamsterVorListener());
		SimulationManager.getSimulationManager().addObserver(this.forwardMenuItem);
		this.hamsterMenu.add(this.forwardMenuItem);
		
		this.turnLeftMenuItem = new OMenuItem(SimulationState.NOT_RUNNING);
		this.turnLeftMenuItem.setText(Resources.getValue("item.turnLeft.text"));
		this.turnLeftMenuItem.setToolTipText(Resources.getValue("item.turnLeft.tooltip"));
		this.turnLeftMenuItem.setMnemonic(Resources.getValue("item.turnLeft.mnemonic").charAt(0));
		this.turnLeftMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.turnLeft.accelerator")));
		this.turnLeftMenuItem.setEnabled(true);
		this.turnLeftMenuItem.addActionListener(new HamsterLinksUmListener());
		SimulationManager.getSimulationManager().addObserver(this.turnLeftMenuItem);
		this.hamsterMenu.add(this.turnLeftMenuItem);
		
		this.takeMenuItem = new OMenuItem(SimulationState.NOT_RUNNING);
		this.takeMenuItem.setText(Resources.getValue("item.take.text"));
		this.takeMenuItem.setToolTipText(Resources.getValue("item.take.tooltip"));
		this.takeMenuItem.setMnemonic(Resources.getValue("item.take.mnemonic").charAt(0));
		this.takeMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.take.accelerator")));
		this.takeMenuItem.setEnabled(true);
		this.takeMenuItem.addActionListener(new HamsterNimmListener());
		SimulationManager.getSimulationManager().addObserver(this.takeMenuItem);
		this.hamsterMenu.add(this.takeMenuItem);
		
		this.giveMenuItem = new OMenuItem(SimulationState.NOT_RUNNING);
		this.giveMenuItem.setText(Resources.getValue("item.give.text"));
		this.giveMenuItem.setToolTipText(Resources.getValue("item.give.tooltip"));
		this.giveMenuItem.setMnemonic(Resources.getValue("item.give.mnemonic").charAt(0));
		this.giveMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.give.accelerator")));
		this.giveMenuItem.setEnabled(true);
		this.giveMenuItem.addActionListener(new HamsterGibListener());
		SimulationManager.getSimulationManager().addObserver(this.giveMenuItem);
		this.hamsterMenu.add(this.giveMenuItem);
	}

	void initSimulationMenu() {
		this.simulationMenu = new JMenu(
				Resources.getValue("menu.simulation.text"));
		this.simulationMenu.setMnemonic(Resources.getValue(
				"menu.simulation.mnemonic").charAt(0));
		
		this.runMenuItem = new OMenuItem(SimulationState.NOT_RUNNING, SimulationState.PAUSED);
		this.runMenuItem.setText(Resources.getValue("item.run.text"));
		this.runMenuItem.setToolTipText(Resources.getValue("item.run.tooltip"));
		this.runMenuItem.setMnemonic(Resources.getValue("item.run.mnemonic").charAt(0));
		this.runMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources.getValue("item.run.accelerator")));
		this.runMenuItem.setEnabled(true);
		this.runMenuItem.addActionListener(new RunListener());
		SimulationManager.getSimulationManager().addObserver(this.runMenuItem);
		this.simulationMenu.add(this.runMenuItem);

		this.pauseMenuItem = new OMenuItem(SimulationState.RUNNING);
		this.pauseMenuItem.setText(Resources.getValue("item.pause.text"));
		this.pauseMenuItem.setToolTipText(Resources
				.getValue("item.pause.tooltip"));
		this.pauseMenuItem.setMnemonic(Resources
				.getValue("item.pause.mnemonic").charAt(0));
		this.pauseMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources
				.getValue("item.pause.accelerator")));
		this.pauseMenuItem.setEnabled(false);
		this.pauseMenuItem.addActionListener(new PauseListener());
		SimulationManager.getSimulationManager()
				.addObserver(this.pauseMenuItem);
		this.simulationMenu.add(this.pauseMenuItem);

		this.stopMenuItem = new OMenuItem(SimulationState.RUNNING,
				SimulationState.PAUSED);
		this.stopMenuItem.setText(Resources.getValue("item.stop.text"));
		this.stopMenuItem.setToolTipText(Resources
				.getValue("item.stop.tooltip"));
		this.stopMenuItem.setMnemonic(Resources.getValue("item.stop.mnemonic")
				.charAt(0));
		this.stopMenuItem.setAccelerator(KeyStroke.getKeyStroke(Resources
				.getValue("item.stop.accelerator")));
		this.stopMenuItem.setEnabled(false);
		this.stopMenuItem.addActionListener(new StopListener());
		SimulationManager.getSimulationManager().addObserver(this.stopMenuItem);
		this.simulationMenu.add(this.stopMenuItem);
	}

	void initToolbar() {
		this.toolBar = new JToolBar();
		this.toolBar.setBackground(new Color(255, 215, 180));

		this.saveButton = new JButton(ImageLoader.getImageIcon("Save24.gif"));
		this.saveButton.setToolTipText(Resources
				.getValue("toolbar.save.tooltip"));
		this.saveButton.setMargin(new Insets(0, 0, 0, 0));
		this.saveButton.addActionListener(new SaveProgramListener());
		this.toolBar.add(this.saveButton);

		this.compileButton = new OButton(
				ImageLoader.getImageIcon("Compile24.gif"),
				SimulationState.NOT_RUNNING);
		this.compileButton.setToolTipText(Resources
				.getValue("toolbar.compile.tooltip"));
		this.compileButton.setMargin(new Insets(0, 0, 0, 0));
		this.compileButton.addActionListener(new CompileProgramListener());
		SimulationManager.getSimulationManager()
				.addObserver(this.compileButton);
		this.toolBar.add(this.compileButton);

		this.toolBar.add(Box.createRigidArea(new Dimension(24, 24)));

		
		
		this.sizeTerButton = new OButton(ImageLoader.getImageIcon("ChangeSize24.png"), SimulationState.NOT_RUNNING);
		this.sizeTerButton.setToolTipText(Resources.getValue("toolbar.changesize.tooltip"));
		this.sizeTerButton.setMargin(new Insets(0, 0, 0, 0));
		this.sizeTerButton.addActionListener(new ChangeSizeListener(sizeTerMenuItem, territoriumMenu));
		this.sizeTerButton.setSelected(true);
		this.toolBar.add(this.sizeTerButton);
		
		
		this.cursorButton = new JToggleButton(ImageLoader.getImageIcon("Cursor24.png"));
		this.cursorButton.setToolTipText(Resources.getValue("toolbar.cursor.tooltip"));
		this.cursorButton.setMargin(new Insets(0, 0, 0, 0));
		this.cursorButton.addActionListener(new CursorButtonListener());
		this.cursorButton.setSelected(true);
		this.toolBar.add(this.cursorButton);
		
		this.cornButton = new JToggleButton(ImageLoader.getImageIcon("Corn24.gif"));
		this.cornButton.setToolTipText(Resources.getValue("toolbar.corn.tooltip"));
		this.cornButton.setMargin(new Insets(0, 0, 0, 0));
		this.cornButton.addActionListener(new CornButtonListener());
		this.toolBar.add(this.cornButton);

		this.wallButton = new JToggleButton(ImageLoader.getImageIcon("Wall24.gif"));
		this.wallButton.setToolTipText(Resources.getValue("toolbar.wall.tooltip"));
		this.wallButton.setMargin(new Insets(0, 0, 0, 0));
		this.wallButton.addActionListener(new WallButtonListener());
		this.toolBar.add(this.wallButton);

		this.clearButton = new JToggleButton(
				ImageLoader.getImageIcon("Clear24.gif"));
		this.clearButton.setToolTipText(Resources
				.getValue("toolbar.clear.tooltip"));
		this.clearButton.setMargin(new Insets(0, 0, 0, 0));
		this.clearButton.addActionListener(new ClearButtonListener());
		this.toolBar.add(this.clearButton);

		ButtonGroup group = new ButtonGroup();
		group.add(this.cursorButton);
		group.add(this.cornButton);
		group.add(this.wallButton);
		group.add(this.clearButton);

		this.toolBar.add(Box.createRigidArea(new Dimension(24, 24)));

		
		this.runAllTestsButton = new OButton(ImageLoader.getImageIcon("TDDRun24.gif"), SimulationState.NOT_RUNNING);
		this.runAllTestsButton.setEnabled(true);
		this.runAllTestsButton.addActionListener(new RunAllTestsListener(this));
		SimulationManager.getSimulationManager().addObserver(this.runAllTestsButton);
		this.runAllTestsButton.setToolTipText(Resources.getValue("toolbar.runAllTestsButton.tooltip"));
		this.runAllTestsButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.runAllTestsButton);
		
		
		this.runButton = new OButton(ImageLoader.getImageIcon("Run24.gif"), SimulationState.NOT_RUNNING, SimulationState.PAUSED);
		this.runButton.setEnabled(true);
		this.runButton.addActionListener(new RunListener());
		SimulationManager.getSimulationManager().addObserver(this.runButton);
		this.runButton.setToolTipText(Resources.getValue("toolbar.run.tooltip"));
		this.runButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.runButton);

		this.pauseButton = new OButton(ImageLoader.getImageIcon("Pause24.gif"),
				SimulationState.RUNNING);
		this.pauseButton.setEnabled(false);
		this.pauseButton.addActionListener(new PauseListener());
		SimulationManager.getSimulationManager().addObserver(this.pauseButton);
		this.pauseButton.setToolTipText(Resources
				.getValue("toolbar.pause.tooltip"));
		this.pauseButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.pauseButton);

		this.stopButton = new OButton(ImageLoader.getImageIcon("Stop24.gif"), SimulationState.PAUSED, SimulationState.RUNNING);
		this.stopButton.setEnabled(false);
		this.stopButton.addActionListener(new StopListener());
		SimulationManager.getSimulationManager().addObserver(this.stopButton);
		this.stopButton.setToolTipText(Resources.getValue("toolbar.stop.tooltip"));
		this.stopButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.stopButton);

		this.toolBar.add(Box.createRigidArea(new Dimension(24, 24)));

		this.speedSlider = new JSlider(SwingConstants.HORIZONTAL,
				SimulationManager.MIN_SPEED, SimulationManager.MAX_SPEED,
				SimulationManager.DEF_SPEED);
		this.speedSlider.setToolTipText(Resources
				.getValue("toolbar.speed.tooltip"));
		this.speedSlider.setMajorTickSpacing(50);
		this.speedSlider.setMinorTickSpacing(25);
		this.speedSlider.setPaintTicks(true);
		this.speedSlider.setPaintLabels(false);
		this.speedSlider.setSnapToTicks(false);
		this.speedSlider.setMaximumSize(new Dimension(200, 50));
		this.speedSlider.setMinimumSize(new Dimension(100, 50));
		this.speedSlider.setBackground(this.toolBar.getBackground());
		this.speedSlider.addChangeListener(new SpeedListener());
		this.toolBar.add(this.speedSlider);
		
		this.toolBar.add(Box.createRigidArea(new Dimension(24, 24)));
		
		
		this.forwardButton = new OButton(ImageLoader.getImageIcon("Forward24.png"), SimulationState.NOT_RUNNING);
		this.forwardButton.setEnabled(true);
		this.forwardButton.addActionListener(new HamsterVorListener());
		SimulationManager.getSimulationManager().addObserver(this.forwardButton);
		this.forwardButton.setToolTipText(Resources.getValue("toolbar.forward.tooltip"));
		this.forwardButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.forwardButton);
		
		this.turnLeftButton = new OButton(ImageLoader.getImageIcon("Turnleft24.png"), SimulationState.NOT_RUNNING);
		this.turnLeftButton.setEnabled(true);
		this.turnLeftButton.addActionListener(new HamsterLinksUmListener());
		SimulationManager.getSimulationManager().addObserver(this.turnLeftButton);
		this.turnLeftButton.setToolTipText(Resources.getValue("toolbar.turnLeft.tooltip"));
		this.turnLeftButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.turnLeftButton);
		
		this.takeButton = new OButton(ImageLoader.getImageIcon("AddCorn24.png"), SimulationState.NOT_RUNNING);
		this.takeButton.setEnabled(true);
		this.takeButton.addActionListener(new HamsterNimmListener());
		SimulationManager.getSimulationManager().addObserver(this.takeButton);
		this.takeButton.setToolTipText(Resources.getValue("toolbar.take.tooltip"));
		this.takeButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.takeButton);
		
		this.giveButton = new OButton(ImageLoader.getImageIcon("RemoveCorn24.png"), SimulationState.NOT_RUNNING);
		this.giveButton.setEnabled(true);
		this.giveButton.addActionListener(new HamsterGibListener());
		SimulationManager.getSimulationManager().addObserver(this.giveButton);
		this.giveButton.setToolTipText(Resources.getValue("toolbar.give.tooltip"));
		this.giveButton.setMargin(new Insets(0, 0, 0, 0));
		this.toolBar.add(this.giveButton);
	}

	void initMainPanel() {
		this.territoriumPanel = new TerritoriumPanel(this.territorium);
		TerritoryManager.getTerritoryManager().setTerritoriumPanel(
				this.territoriumPanel);
		TerritoryMouseListener ml = new TerritoryMouseListener();
		this.territoriumPanel.addMouseListener(ml);
		this.territoriumPanel.addMouseMotionListener(ml);
		SimulationManager.getSimulationManager().addObserver(ml);

		this.editor = new Editor(ProgramManager.getProgramManager()
				.getHamsterProgram());
		ProgramManager.getProgramManager().setEditor(this.editor);

		JScrollPane editorScrollPane = new JScrollPane(this.editor);
		
		//TODO hier angepasst
		editorScrollPane.setPreferredSize(new Dimension(600, 500));
		//-----------------
		
		//TODO hier angepasst
		
		tabPane = new JTabbedPane();
		tabPane.addTab("TDD", new TDDPanel(TDDFrameworkContainer.getTDDFramework()));
		tabPane.addTab("Editor", editorScrollPane);
		//---------------------

		JScrollPane simulationScrollPane = new JScrollPane(
				this.territoriumPanel);
		simulationScrollPane.setPreferredSize(new Dimension(600, 600));

		
		this.mainPanel = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		
		//TODO hier angepasst
		this.mainPanel.setLeftComponent(tabPane);
		//---------------------
		
		this.mainPanel.setRightComponent(simulationScrollPane);
		this.mainPanel.setOneTouchExpandable(true);
		this.mainPanel.setContinuousLayout(true);
	}
	
	
	public void showTDD() {
		
		tabPane.setSelectedIndex(0);
	}
	

	void initMessagePanel() {
		this.messagePanel = new JTextArea();
		this.messagePanel.setBackground(new Color(220, 250, 250));
		this.messagePanel.setFocusable(false);
		this.messagePanel.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 12));
		this.messagePanel.setMargin(new Insets(5, 5, 5, 5));
		this.messagePanel.setEditable(false);
		this.messagePanel.setLineWrap(false);
		this.messagePanel.setText(Resources.getValue("msg.welcome"));
	}

}
