package view;

import java.util.ArrayList;
import java.util.List;

import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

import util.Observer;
import controller.program.Program;
import controller.program.Workspace;

public class ProgramsModel implements javax.swing.ComboBoxModel<Program> {

	private Program selected;
	private Workspace workspace;
	private List<ListDataListener> listDataListeners = new ArrayList<ListDataListener>();
	
	public ProgramsModel(Workspace workspace) {
	
		if(workspace == null) throw new IllegalArgumentException("workspace is NULL");
		
		this.workspace = workspace;
		this.workspace.addObserver(this.workspaceObserver);
	}
	
	@Override
	public int getSize() {
		
		return this.workspace.getNumberOfPrograms();
	}

	@Override
	public Program getElementAt(int index) {
		
		return this.workspace.getProgram(index);
	}

	@Override
	public void addListDataListener(ListDataListener l) {
	
		this.listDataListeners.add(l);
	}

	@Override
	public void removeListDataListener(ListDataListener l) {
		
		this.listDataListeners.remove(l);
	}

	@Override
	public void setSelectedItem(Object anItem) {
	
		this.selected = (Program) anItem;
	}

	@Override
	public Object getSelectedItem() {
		
		return this.selected;
	}
	
	private void update() {
		
		for(ListDataListener l : this.listDataListeners) {
			
			l.contentsChanged(new ListDataEvent(this, ListDataEvent.CONTENTS_CHANGED, 0, this.workspace.getNumberOfPrograms()));
		}
	}
	
	private final Observer workspaceObserver = new Observer() {
		
		@Override
		public void update() {
			
			ProgramsModel.this.update();
		}
	};
}
