package view;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

import controller.program.CreateProgramListener;
import controller.program.Program;
import controller.program.WorkspaceController;

public class ProgramDialog extends JDialog {

	private static final long serialVersionUID = -3597318383906854893L;

	private boolean commited = false;
	
	private JComboBox<Program> programs;
	private JButton commit;
	
	public ProgramDialog() {
		
		JPanel content = new JPanel(new BorderLayout());
		
		programs = new JComboBox<Program>(new ProgramsModel(WorkspaceController.getInstance().getWorkspace()));
		programs.addItemListener(this.programsItemListener);
		content.add(programs, BorderLayout.CENTER);
		
		JPanel bottom = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		content.add(bottom, BorderLayout.SOUTH);
		
		JButton create = new JButton("Erstellen");
		create.addActionListener(new CreateProgramListener(false));
		bottom.add(create);
		
		commit = new JButton("Übernehmen");
		commit.addActionListener(this.commitActionListener);
		commit.setEnabled(false);
		bottom.add(commit);
		
		JButton cancel = new JButton("Abbrechen");
		cancel.addActionListener(this.cancelActionListener);
		bottom.add(cancel);
		
		this.setContentPane(content);
		this.setModal(true);
		this.pack();
		this.setTitle("Programm wählen");
		this.setLocationRelativeTo(null);
	}
	
	public boolean isCommited() {
		
		return this.commited;
	}
	
	public Program getProgram() {
		
		return (Program) this.programs.getSelectedItem();
	}
	
	private final ItemListener programsItemListener = new ItemListener() {
		
		@Override
		public void itemStateChanged(ItemEvent e) {
			
			commit.setEnabled(programs.getSelectedItem() != null);
		}
	};

	private final ActionListener commitActionListener = new ActionListener() {

		@Override
		public void actionPerformed(ActionEvent e) {
			
			commited = true;
			setVisible(false);
		}
	};
	
	private final ActionListener cancelActionListener = new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {
			
			setVisible(false);
		}
	};
}
