package view;

import javax.swing.JMenuItem;

import util.Observer;
import controller.simulation.SimulationManager;
import controller.simulation.SimulationState;

public class OMenuItem extends JMenuItem implements Observer {

	private SimulationState[] enabled;

	public OMenuItem(SimulationState... enabled) {
		super();
		this.enabled = enabled;
	}

	@Override
	public void update() {
		SimulationState currentState = SimulationManager.getSimulationManager()
				.getState();

		for (SimulationState e : enabled) {
			if (e == currentState) {
				this.setEnabled(true);
				return;
			}
		}
		this.setEnabled(false);
	}
}
