package view;

import javax.swing.ImageIcon;
import javax.swing.JButton;

import util.Observer;
import controller.simulation.SimulationManager;
import controller.simulation.SimulationState;

public class OButton extends JButton implements Observer {

	private SimulationState[] enabled;

	
	public OButton(String text, SimulationState... enabled) {
		super(text);
		this.enabled = enabled;
	}
	
	public OButton(ImageIcon icon, SimulationState... enabled) {
		super(icon);
		this.enabled = enabled;
	}

	@Override
	public void update() {
		SimulationState currentState = SimulationManager.getSimulationManager()
				.getState();

		for (SimulationState e : enabled) {
			if (e == currentState) {
				this.setEnabled(true);
				return;
			}
		}
		this.setEnabled(false);
	}
}
