package view;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import annotations.Ignore;

import com.sun.xml.internal.bind.v2.schemagen.xmlschema.Annotation;

import model.Hamster;
import model.Invisible;
import controller.simulation.MethodInvocation;
import controller.territory.TerritoryManager;

public class HamsterPopupMenu extends JPopupMenu {

	public HamsterPopupMenu() {
		TerritoryManager manager = TerritoryManager.getTerritoryManager();
		Method[] methods = this.getMethods(manager.getTerritorium()
				.getHamster());
		for (Method method : methods) {
			JMenuItem m = new JMenuItem(this.genMethodName(method));
			if (method.getParameterTypes().length == 0) {
				m.addActionListener(new MethodInvocation(method, manager
						.getTerritorium().getHamster(), manager
						.getTerritorium()));
			} else {
				m.setEnabled(false);
			}
			this.add(m);
		}
	}

	public Method[] getMethods(Hamster hamster) {
		ArrayList<Method> res = new ArrayList<Method>();
		for (Method method : Hamster.class.getDeclaredMethods()) {
			
			Ignore ignore = method.getAnnotation(Ignore.class);
			
			if(ignore == null) {
				
				if (!this.isMainMethod(method)) {
					res.add(method);
				}
			}
		}
		if (Hamster.class != hamster.getClass()) {
			for (Method method : hamster.getClass().getDeclaredMethods()) {

				if (!Modifier.isPrivate(method.getModifiers())
						&& !Modifier.isAbstract(method.getModifiers())
						&& !Modifier.isStatic(method.getModifiers())
						&& method.getAnnotation(Invisible.class) == null) {
					res.add(method);
				}
			}
		}
		return res.toArray(new Method[0]);
	}

	public String genMethodName(Method method) {
		String str = new String();

		str += method.getReturnType().getName();
		str += " " + method.getName() + "(";

		Class<?>[] parameterTypes = method.getParameterTypes();
		for (int k = 0; k < parameterTypes.length; k++) {
			str += parameterTypes[k].getName();
			if (k < parameterTypes.length - 1) {
				str += ", ";
			}
		}
		str += " )";
		return str;
	}

	private boolean isMainMethod(Method method) {
		return method.getName().equals("main")
				&& method.getParameterTypes().length == 0
				&& method.getReturnType().getName().equals("void");
	}

}
