package view;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;

import controller.program.CompileManager;

public class Editor extends RSyntaxTextArea {

	private static final long serialVersionUID = 5039096169511731877L;
	
	
	final Color editorColor = new Color(170, 255, 190);
	final Color printColor = Color.WHITE;

	public Editor(String program) {
		this.setBackground(this.editorColor);
		this.setFocusable(true);
		this.setFont(new Font(Font.MONOSPACED, Font.PLAIN, 12));
		this.setMargin(new Insets(5, 5, 5, 5));
		this.setEditable(true);
		this.setLineWrap(false);
		this.setText(program);
		this.setSyntaxEditingStyle(SyntaxConstants.SYNTAX_STYLE_JAVA);
		this.setCodeFoldingEnabled(true);
		
		this.getDocument().addDocumentListener(this.documentListener);
	}

	
	private final DocumentListener documentListener = new DocumentListener() {
		
		@Override
		public void removeUpdate(DocumentEvent e) {
			
			CompileManager.getCompileManager().getCompiledState().setCompiled(false);
		}
		
		@Override
		public void insertUpdate(DocumentEvent e) {

			CompileManager.getCompileManager().getCompiledState().setCompiled(false);
		}
		
		@Override
		public void changedUpdate(DocumentEvent e) {

			CompileManager.getCompileManager().getCompiledState().setCompiled(false);
		}
	};
}
