package util;

import java.io.FileInputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

import javax.swing.JComponent;

public class Resources {

	static Locale locale = null;

	private static ResourceBundle bundle = null;

	public static void init() {
		Properties prop = new Properties();
		try {
			prop.load(new FileInputStream("hamster.properties"));
			String localeStr = prop.getProperty("language");
			if (localeStr == null) {
				Resources.locale = Locale.getDefault();
			} else {
				Resources.locale = new Locale(localeStr);
			}
		} catch (Throwable e) {
			Resources.locale = Locale.getDefault();
		}
		Locale.setDefault(Resources.locale);
		JComponent.setDefaultLocale(Resources.locale);
		Resources.bundle = ResourceBundle.getBundle("resources.hamster",
				Resources.locale);
	}

	public static String getValue(String key) {
		return Resources.bundle.getString(key);
	}

	public static Locale getLocale() {
		return Resources.locale;
	}
}
