package util;

import java.util.ArrayList;


// Anmerkung:
// Reimplementierung notwendig, weil bei java.util.Observable keine Reihenfolge definiert ist, in der die Observer
// benachrichtigt werden. Das ist in unserem Falle aber notwendig.

public class Observable {

	private ArrayList<Observer> observers;
	private boolean notification;

	public Observable() {
		this.observers = new ArrayList<Observer>();
		this.notification = true;
	}

	public void addObserver(Observer o) {
		this.observers.add(o);
	}

	public void deleteObserver(Observer o) {
		this.observers.remove(o);
	}

	public void deleteObservers() {
		this.observers.clear();
	}

	public Observer[] getObservers() {
		//TODO angepasst.... zu array
		return this.observers.toArray(new Observer[this.observers.size()]);
	}
 
	public void activateNotification() {
		this.notification = true;
		this.notifyObservers();
	}

	public void deactivateNotification() {
		this.notification = false;
	}

	public void notifyObservers() {
		if (notification) {
			
			//TODO Abarbeitung der Observer gegen java.util.ConcurrentModificationException absichern
			Observer[] observers = this.observers.toArray(new Observer[this.observers.size()]);
			
			for (Observer o : observers) {
				o.update();
			}
		}
	}

}
