package tdd.views.menus;



import java.util.Objects;

import javax.swing.JPopupMenu;

import tdd.controllers.TestRunner;
import tdd.controllers.TestsuiteController;
import tdd.models.Testsuite;
import tdd.views.menus.items.CreateTestMenu;
import tdd.views.menus.items.CreateTestsuiteMenuItem;
import tdd.views.menus.items.DeleteTestsuiteMenuItem;
import tdd.views.menus.items.RunTestsuiteMenuItem;



public class TestsuitePopupMenu extends JPopupMenu {

	
	
	private static final long serialVersionUID = -3090909373983907580L;

	
	
	public TestsuitePopupMenu(TestsuiteController testsuiteController, TestRunner testRunner, Testsuite testsuite) {
	
		Testsuite root = testsuiteController.getTestsuiteContainer().getTestsuite();
		
		this.add(new RunTestsuiteMenuItem(testRunner, testsuite));
		this.add(new CreateTestsuiteMenuItem(testsuiteController, testsuite));
		this.add(new CreateTestMenu(testsuiteController, testsuite));
		
		if(!Objects.equals(root, testsuite)) {
			
			this.add(new DeleteTestsuiteMenuItem(testsuiteController, testsuite));
		}
	}
}
