package tdd.views;



import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.List;

import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

import tdd.controllers.TestRunner;
import tdd.controllers.TestsuiteController;
import tdd.models.TestsuiteContainer;



public class TestsuiteTreeView extends JTree {

	
	
	private static final long serialVersionUID = -1385547183975642996L;

	
	
	private TestsuiteController testsuiteController;
	

	
	public TestsuiteTreeView(TestsuiteController testsuiteController, TestRunner testRunner, TestsuiteContainer testsuiteContainer) {
		
		super( new TestsuiteTreeModel(testsuiteController, testRunner, testsuiteContainer));
		
		//TODO geht vll besser?!
		for(int i=0; i<this.getRowCount(); i++) {
			
			this.expandRow(i);
		}
		//---------------------
		
		this.testsuiteController = testsuiteController;
		this.addMouseListener(mouseAdapter);
		this.setDragEnabled(true);
		this.setDropMode(DropMode.ON_OR_INSERT);
		this.setTransferHandler(new TreeTransferHandler());
		this.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
	}
	
	
	
	private final MouseAdapter mouseAdapter = new MouseAdapter() {
		
		public void mousePressed(java.awt.event.MouseEvent e) {
			
			TreePath path = TestsuiteTreeView.this.getPathForLocation(e.getX(), e.getY());
			
			if(path == null) return;
			
			Object node = path.getLastPathComponent();

			if(node == null) return;
			
			
			if(SwingUtilities.isRightMouseButton(e)) {
				
				if(node instanceof AbstractTestsuitePopupTreeNode) {
					
					((AbstractTestsuitePopupTreeNode) node).handlePopup(TestsuiteTreeView.this, e.getX(), e.getY());
				}
				
			} else if(e.getClickCount() == 2) {
				
				if(node instanceof TestTreeNode) {
					
					testsuiteController.showTest(((TestTreeNode) node).getTest());
				}
			}
		}
	};
	
	private class TreeTransferHandler extends TransferHandler {

		private static final long serialVersionUID = -895385630416064923L;
		
	    private DataFlavor nodesFlavor;
	    private DataFlavor[] flavors = new DataFlavor[1];
	    private AbstractTestsuiteTreeNode[] nodesToRemove;

	    public TreeTransferHandler() {
	    	
	        try {
	        	
	            String mimeType = DataFlavor.javaJVMLocalObjectMimeType +
	                              ";class=\"" +
	                              AbstractTestsuiteTreeNode[].class.getName() +
	                              "\"";
	            nodesFlavor = new DataFlavor(mimeType);
	            flavors[0] = nodesFlavor;
	            
	        } catch(ClassNotFoundException e) {
	        	
	            System.out.println("ClassNotFound: " + e.getMessage());
	        }
	    }

	    public boolean canImport(TransferHandler.TransferSupport support) {
	        if(!support.isDrop()) {
	            return false;
	        }
	        support.setShowDropLocation(true);
	        if(!support.isDataFlavorSupported(nodesFlavor)) {
	            return false;
	        }
	        // Do not allow a drop on the drag source selections.
	        JTree.DropLocation dl = (JTree.DropLocation) support.getDropLocation();
	        JTree tree = (JTree) support.getComponent();
	        int dropRow = tree.getRowForPath(dl.getPath());
	        int[] selRows = tree.getSelectionRows();
	        for(int i = 0; i < selRows.length; i++) {
	            if(selRows[i] == dropRow) {
	                return false;
	            }
	        }
	        // Do not allow MOVE-action drops if a non-leaf node is
	        // selected unless all of its children are also selected.
	        int action = support.getDropAction();
	        if(action == MOVE) {
	            return haveCompleteNode(tree);
	        }
	        // Do not allow a non-leaf node to be copied to a level
	        // which is less than its source level.
	        TreePath dest = dl.getPath();
	        AbstractTestsuiteTreeNode target = (AbstractTestsuiteTreeNode) dest.getLastPathComponent();
	        
	        if(!(target instanceof TestsuiteTreeNode)) return false;
	        
	        TreePath path = tree.getPathForRow(selRows[0]);
	        AbstractTestsuiteTreeNode firstNode = (AbstractTestsuiteTreeNode) path.getLastPathComponent();
	        if(firstNode.getNumberOfChilds() > 0 && target.getLevel() < firstNode.getLevel()) {
	        	
	            return false;
	        }
	        return true;
	    }

	    private boolean haveCompleteNode(JTree tree) {
	    	
	        int[] selRows = tree.getSelectionRows();
	        TreePath path = tree.getPathForRow(selRows[0]);
	        
	        AbstractTestsuiteTreeNode first = (AbstractTestsuiteTreeNode) path.getLastPathComponent();
	        int childCount = first.getNumberOfChilds();
	        // first has children and no children are selected.
	        if(childCount > 0 && selRows.length == 1)
	            return false;
	        // first may have children.
	        for(int i = 1; i < selRows.length; i++) {
	        	
	            path = tree.getPathForRow(selRows[i]);
	            AbstractTestsuiteTreeNode next = (AbstractTestsuiteTreeNode) path.getLastPathComponent();
	            
	            if(first.isNodeChild(next)) {
	                // Found a child of first.
	                if(childCount > selRows.length-1) {
	                    // Not all children of first are selected.
	                    return false;
	                }
	            }
	        }
	        return true;
	    }

	    protected Transferable createTransferable(JComponent c) {
	    	
	        JTree tree = (JTree) c;
	        TreePath[] paths = tree.getSelectionPaths();
	        
	        if(paths != null) {
	        
	            List<AbstractTestsuiteTreeNode> toRemove = new ArrayList<AbstractTestsuiteTreeNode>();
	            AbstractTestsuiteTreeNode node =(AbstractTestsuiteTreeNode)paths[0].getLastPathComponent();

	            toRemove.add(node);

	            nodesToRemove = toRemove.toArray(new AbstractTestsuiteTreeNode[toRemove.size()]);
	            
	            return new NodesTransferable(nodesToRemove);
	        }
	        return null;
	    }
	 
	    public int getSourceActions(JComponent c) {
	        return COPY_OR_MOVE;
	    }

	    public boolean importData(TransferHandler.TransferSupport support) {
	    	
	        if(!canImport(support)) {
	            return false;
	        }
	        // Extract transfer data.
	        AbstractTestsuiteTreeNode[] nodes = null;
	        
	        try {
	        	
	            Transferable t = support.getTransferable();
	            nodes = (AbstractTestsuiteTreeNode[]) t.getTransferData(nodesFlavor);
	            
	        } catch(UnsupportedFlavorException ufe) {
	            System.out.println("UnsupportedFlavor: " + ufe.getMessage());
	        } catch(java.io.IOException ioe) {
	            System.out.println("I/O error: " + ioe.getMessage());
	        }
	        // Get drop location info.
	        JTree.DropLocation dl = (JTree.DropLocation) support.getDropLocation();
	        TreePath dest = dl.getPath();
	        AbstractTestsuiteTreeNode parent = (AbstractTestsuiteTreeNode) dest.getLastPathComponent();

	        // Add data to model.
	        for(int i = 0; i < nodes.length; i++) {
	        	
	        	if(parent instanceof TestsuiteTreeNode) {
	        		
	        		TestsuiteTreeNode parentNode = (TestsuiteTreeNode) parent;
	        		
	        		if(nodes[i] instanceof TestTreeNode) {
		        		
		        		TestTreeNode node = (TestTreeNode) nodes[i];
		        		
		        		testsuiteController.moveTest(parentNode.getTestsuite(), node.getTest());
		        		
		        	} else if(nodes[i] instanceof TestsuiteTreeNode) {
		        		
		        		TestsuiteTreeNode node = (TestsuiteTreeNode) nodes[i];
		        		
		        		testsuiteController.moveTestsuite(parentNode.getTestsuite(), node.getTestsuite());
		        	}	
	        	}
	        }
	        return true;
	    }

	    public String toString() {
	        return getClass().getName();
	    }

	    public class NodesTransferable implements Transferable {
	    	AbstractTestsuiteTreeNode[] nodes;

	        public NodesTransferable(AbstractTestsuiteTreeNode[] nodes) {
	            this.nodes = nodes;
	         }

	        public Object getTransferData(DataFlavor flavor)
	                                 throws UnsupportedFlavorException {
	            if(!isDataFlavorSupported(flavor))
	                throw new UnsupportedFlavorException(flavor);
	            return nodes;
	        }

	        public DataFlavor[] getTransferDataFlavors() {
	            return flavors;
	        }

	        public boolean isDataFlavorSupported(DataFlavor flavor) {
	            return nodesFlavor.equals(flavor);
	        }
	    }
	}
}
