package tdd.views;



import javax.swing.JTree;

import tdd.controllers.TestRunner;
import tdd.controllers.TestsuiteController;
import tdd.models.Test;
import tdd.models.Testsuite;
import tdd.views.menus.TestsuitePopupMenu;
import util.Observer;



public class TestsuiteTreeNode extends AbstractTestsuitePopupTreeNode {
	
	
	
	private TestsuiteTreeModel testsuiteTreeModel;
	private TestsuiteController testsuiteController;
	private TestRunner testRunner;
	private Testsuite testsuite;
	
	
	
	public TestsuiteTreeNode(
			TestsuiteTreeModel testsuiteTreeModel, 
			AbstractTestsuiteTreeNode parent, 
			TestsuiteController testsuiteController, 
			TestRunner testRunner,
			Testsuite testsuite) {
		
		super(testsuiteTreeModel, parent, testsuite);
		
		this.testsuiteTreeModel = testsuiteTreeModel;
		this.testsuiteController = testsuiteController;
		this.testRunner = testRunner;
		
		this.testsuite = testsuite;
		this.testsuite.addObserver(this.testsuiteObserver);
		
		this.updateStructure();
	}
	
	
	
	public TestsuiteTreeModel getTestsuiteTreeModel() {
		
		return this.testsuiteTreeModel;
	}

	public TestsuiteController getTestsuiteController() {
		
		return this.testsuiteController;
	}
	
	public TestRunner getTestRunner() {
		
		return this.testRunner;
	}
	
	public Testsuite getTestsuite() {
		
		return this.testsuite;
	}
	
	
	
	@Override
	public void handlePopup(JTree tree, int x, int y) {
		
		new TestsuitePopupMenu(this.getTestsuiteController(), this.getTestRunner(), this.getTestsuite()).show(tree, x, y);
	}
	
	private void updateStructure() {
		
		//add nodes
		for(Testsuite testsuite : this.getTestsuite().getTestsuites()) {
			
			if(!this.contains(testsuite)) {
				
				this.add(new TestsuiteTreeNode(this.getTestsuiteTreeModel(), this, this.getTestsuiteController(), this.getTestRunner(), testsuite));
			}
		}
		
		for(Test test : this.getTestsuite().getTests()) {
			
			if(!this.contains(test)) {
				
				this.add(new TestTreeNode(this.getTestsuiteTreeModel(), this, this.getTestsuiteController(), this.getTestRunner(), test));
			}
		}
		
		//remove nodes
		for(AbstractTestsuiteTreeNode node : this.getChilds()) {
			
			if(!this.getTestsuite().contains(node.getValue())) {
				
				this.remove(node);
			}
		}
	}
	
	
	
	private final Observer testsuiteObserver = new Observer() {
		
		@Override
		public void update() {
			
			TestsuiteTreeNode.this.updateStructure();
		}
	};
}
