package tdd.views;



import java.util.ArrayList;
import java.util.List;

import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

import tdd.controllers.TestRunner;
import tdd.controllers.TestsuiteController;
import tdd.models.Testsuite;
import tdd.models.TestsuiteContainer;
import util.Observer;



public class TestsuiteTreeModel implements TreeModel {

	
	
	private TestsuiteController testsuiteController;
	private TestRunner testRunner;
	private TestsuiteContainer testsuiteContainer;
	private TestsuiteTreeNode root;
	private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
	
	
	
	public TestsuiteTreeModel(TestsuiteController testsuiteController, TestRunner testRunner, TestsuiteContainer testsuiteContainer) {

		this.testsuiteController = testsuiteController;
		this.testRunner = testRunner;
		
		this.testsuiteContainer = testsuiteContainer;
		this.testsuiteContainer.addObserver(this.testsuiteContainerObserver);
		
		this.update();
	}
	
	
	
	public TestsuiteController getTestsuiteController() {
		
		return this.testsuiteController;
	}
	
	public TestRunner getTestRunner() {
		
		return this.testRunner;
	}
	
	public TestsuiteContainer getTestsuiteContainer() {
		
		return this.testsuiteContainer;
	}
	

	
	public void removeNodeFromParent(AbstractTestsuiteTreeNode node) {
		
		AbstractTestsuiteTreeNode parent = this.root;
		this.removeNodeFromParent(parent, node);
	}
	
	private void removeNodeFromParent(AbstractTestsuiteTreeNode parent, AbstractTestsuiteTreeNode node) {
		
		for(AbstractTestsuiteTreeNode child : parent.getChilds()) {
			
			this.removeNodeFromParent(child, node);
		}
		
		if(parent.getNumberOfChilds() > 0) {
			
			if(parent.contains(node)) {
				
				parent.remove(node);
				
				return;
			}
		}
		
	}
	
	@Override
	public Object getRoot() {
		
		return this.root;
	}

	@Override
	public Object getChild(Object parent, int index) {
	
		if(parent instanceof AbstractTestsuiteTreeNode) {
			
			AbstractTestsuiteTreeNode node = (AbstractTestsuiteTreeNode) parent;
			
			return node.get(index);
		}
		
		return null;
	}

	@Override
	public int getChildCount(Object parent) {
		
		if(parent instanceof AbstractTestsuiteTreeNode) {
			
			AbstractTestsuiteTreeNode node = (AbstractTestsuiteTreeNode) parent;
			
			return node.getNumberOfChilds();
		}
		
		return 0;
	}

	@Override
	public boolean isLeaf(Object node) {
	
		if(node instanceof TestsuiteTreeNode) return false;
		
		return true;
	}

	@Override
	public void valueForPathChanged(TreePath path, Object newValue) {}

	@Override
	public int getIndexOfChild(Object parent, Object child) {
		
		if(parent instanceof AbstractTestsuiteTreeNode && child instanceof AbstractTestsuiteTreeNode) {
			
			AbstractTestsuiteTreeNode node = (AbstractTestsuiteTreeNode) parent;
			AbstractTestsuiteTreeNode childNode = (AbstractTestsuiteTreeNode) child;
			
			return node.getIndexOfChild(childNode);
		}
		
		return 0;
	}
	
	public void inserted(AbstractTestsuiteTreeNode[] path, int[] childIndices, AbstractTestsuiteTreeNode[] children) {
		
		for(TreeModelListener l : this.listeners) {
			
			l.treeNodesInserted(new TreeModelEvent(this, path, childIndices, children));
		}
	}
	
	public void removed(AbstractTestsuiteTreeNode[] path, int[] childIndices, AbstractTestsuiteTreeNode[] children) {
		
		for(TreeModelListener l : this.listeners) {
			
			l.treeNodesRemoved(new TreeModelEvent(this, path, childIndices, children));
		}
	}

	@Override
	public void addTreeModelListener(TreeModelListener l) {
		
		this.listeners.add(l);
	}

	@Override
	public void removeTreeModelListener(TreeModelListener l) {

		this.listeners.remove(l);
	}
	
	private void update() {
		
		Testsuite testsuite = this.getTestsuiteContainer().getTestsuite();
		
		if(testsuite != null) {
			
			this.root = new TestsuiteTreeNode(this,  null, this.getTestsuiteController(), this.getTestRunner(), testsuite);
			
		} else {
			
			this.root = null;
		}
		
		for(TreeModelListener l : this.listeners) {
			
			l.treeStructureChanged(new TreeModelEvent(this, new Object[] {}));
		}
	}
	
	
	
	private final Observer testsuiteContainerObserver = new Observer() {
		
		@Override
		public void update() {
			
			TestsuiteTreeModel.this.update();
		}
	};
}
