package tdd.views;



import javax.swing.JTree;

import tdd.controllers.TestRunner;
import tdd.controllers.TestsuiteController;
import tdd.models.Test;
import tdd.views.menus.TestPopupMenu;



public class TestTreeNode extends AbstractTestsuitePopupTreeNode {

	
	
	private TestsuiteController testsuiteController;
	private TestRunner testRunner;
	private Test test;
	
	
	
	public TestTreeNode(
			TestsuiteTreeModel testsuiteTreeModel, 
			AbstractTestsuiteTreeNode parent, 
			TestsuiteController testsuiteController,
			TestRunner testRunner,
			Test test) {
	
		super(testsuiteTreeModel, parent, test);
	
		this.testsuiteController = testsuiteController;
		this.testRunner = testRunner;
		this.test = test;
	}
	
	
	
	public TestsuiteController getTestsuiteController() {
		
		return this.testsuiteController;
	}
	
	public TestRunner getTestRunner() {
		
		return this.testRunner;
	}
	
	public Test getTest() {
		
		return this.test;
	}
	
	

	@Override
	public void handlePopup(JTree tree, int x, int y) {
		
		new TestPopupMenu(this.getTestsuiteController(), this.getTestRunner(), this.getTest()).show(tree, x, y);
	}
}
