package tdd.views;



import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

import tdd.models.TestCaseRunInformation;
import tdd.models.TestRunnerInformation;
import util.Observer;



public class TestRunnerInformationTableModel extends AbstractTableModel {


	
	private static final long serialVersionUID = 96238083454562885L;
	
	private static final String[] COLUMNS = new String[] {"Test", "Testfall", "Ergebnis", "Fehler"};
	
	
	
	private TestRunnerInformation testRunnerInformation;
	
	
	
	public TestRunnerInformationTableModel(TestRunnerInformation testRunnerInformation) {
		
		super();
		
		this.testRunnerInformation = testRunnerInformation;
		this.testRunnerInformation.addObserver(this.testRunnerInformationObserver);
	}
	
	
	
	public TestRunnerInformation getTestRunnerInformation() {
		
		return this.testRunnerInformation;
	}
	
	
	
	@Override
	public int getRowCount() {
	
		return this.getTestRunnerInformation().getCountOfTestCaseRunInformations();
	}

	@Override
	public int getColumnCount() {

		return COLUMNS.length;
	}
	
	@Override
	public String getColumnName(int column) {

		return COLUMNS[column];
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
	
		TestCaseRunInformation testCaseRunInformation = this.getTestRunnerInformation().get(rowIndex);
		
		switch(columnIndex) {
		
			case 0: return testCaseRunInformation.getTest();
			case 1: return testCaseRunInformation.getTestCase();
			case 2: return (testCaseRunInformation.isRunning() ? null : (testCaseRunInformation.getError() == null));
			case 3: return testCaseRunInformation.getError();
		}
		
		return null;
	}
	
	
	
	private final Observer testRunnerInformationObserver = new Observer() {
		
		@Override
		public void update() {
			
			SwingUtilities.invokeLater(new Runnable() {
				
				@Override
				public void run() {
					
					fireTableDataChanged();
				}
			});
		}
	};
}
