package tdd.views;



import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Rectangle;

import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;

import tdd.models.TestRunnerInformation;



public class TestRunnerInformationTable extends JTable {

	
	
	private static final long serialVersionUID = 5801250509857735991L;


	
	public TestRunnerInformationTable(TestRunnerInformation testRunnerInformation) {
		
		super(new TestRunnerInformationTableModel(testRunnerInformation));
		
		this.setDefaultRenderer(Object.class, new MultiLineCellRenderer());
	}
	
	
	
	private class MultiLineCellRenderer extends JTextArea implements TableCellRenderer {

		private static final long serialVersionUID = 2432770837423650565L;

		public MultiLineCellRenderer() {
		  
			setLineWrap(true);
			setWrapStyleWord(true);
			setOpaque(true);
		}

		public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
			
			if (isSelected) {
				setForeground(table.getSelectionForeground());
				setBackground(table.getSelectionBackground());
			} else {
				setForeground(table.getForeground());
				setBackground(table.getBackground());
			}
			setFont(table.getFont());

			setText((value == null) ? "" : value.toString());
			
			FontMetrics metrics = this.getFontMetrics(this.getFont());
			
			int fontHeight = metrics.getHeight();
			int textWidth = metrics.stringWidth(this.getText());
			Rectangle cellRectangle = table.getCellRect(row, column, false);
			
			int lines = 1;    
			if(cellRectangle.getWidth() > 0) {
				
				lines += (int) Math.ceil(((double) textWidth) / cellRectangle.getWidth());
			}
			
			int linebreaks = this.getText().split("\n").length;
			
			if(linebreaks > 1) {
				
				lines += linebreaks;
			}
			      
			int height = fontHeight * lines;            
			table.setRowHeight(row, height);
			
			if(value instanceof Boolean) {
				
				boolean v = (Boolean) value;
				
				if(v) this.setBackground(Color.GREEN);
				else this.setBackground(Color.RED);
				
				this.setText(null);
			}
			
			return this;
		}
	}
}
