package tdd.views;



import java.awt.Color;
import java.awt.Dimension;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import tdd.models.TestRunnerInformation;
import util.Observer;



public class TestRunnerInformationPanel extends JPanel {

	
	
	private static final long serialVersionUID = 1012862762816673065L;
	
	private static final int MINIMUM_HEIGHT = 30;
	private static final int MINIMUM_WIDTH = 0;
	
	
	
	private TestRunnerInformation testRunnerInformation;
	
	
	
	public TestRunnerInformationPanel(TestRunnerInformation testRunnerInformation) {
		
		this.testRunnerInformation = testRunnerInformation;
		this.testRunnerInformation.addObserver(this.testRunnerInformationObserver);
		
		this.update();
	}
	
	
	
	public TestRunnerInformation getTestRunnerInformation() {
		
		return this.testRunnerInformation;
	}
	
	
	
	@Override
	public Dimension getMinimumSize() {
		
		return new Dimension(MINIMUM_WIDTH, MINIMUM_HEIGHT);
	}
	
	@Override
	public Dimension getPreferredSize() {
	
		return this.getMinimumSize();
	}
	
	
	private void update() {
		
		if(this.getTestRunnerInformation().getCountOfTestCaseRunInformations() > 0) {
			
			if(this.getTestRunnerInformation().hasAnyError()) {
				
				this.setBackground(Color.RED);
				
			} else {
				
				this.setBackground(Color.GREEN);
			}
			
		} else {
			
			this.setBackground(Color.GRAY);
		}
	}
	
	
	
	private final Observer testRunnerInformationObserver = new Observer() {
		
		@Override
		public void update() {
			
			SwingUtilities.invokeLater(new Runnable() {
				
				@Override
				public void run() {
					
					TestRunnerInformationPanel.this.update();
				}
			});
		}
	};
}
