package tdd.views;



import javax.swing.AbstractListModel;

import tdd.models.TerritoryState;
import tdd.models.TerritoryStates;
import util.Observer;



public class TerritoryStatesListModel extends AbstractListModel<TerritoryState> {


	
	private static final long serialVersionUID = 6722158894560085457L;
	
	
	
	private TerritoryStates territoryStates;
	private boolean showTemp = false;
	
	
	
	public TerritoryStatesListModel(TerritoryStates territoryStates) {
	
		this.territoryStates = territoryStates;
		this.territoryStates.addObserver(this.territoryStatesObserver);
	}
	
	public TerritoryStatesListModel(TerritoryStates territoryStates, boolean showTemp) {
		
		this(territoryStates);
		
		this.showTemp = showTemp;
	}
	
	
	
	public TerritoryStates getTerritoryStates() {
		
		return this.territoryStates;
	}
	
	
	
	@Override
	public int getSize() {

		if(this.showTemp) {
			
			return this.territoryStates.getNumberOfTerritoryStates();
		}
		
		int size = 0;
		
		for(int i=0; i<this.territoryStates.getNumberOfTerritoryStates(); i++) {
			
			if(!this.territoryStates.getTerritoryState(i).isTemp()) {
				
				size++;
			}
		}
		
		return size;
	}

	@Override
	public TerritoryState getElementAt(int index) {
	
		if(this.showTemp) {
			
			return this.territoryStates.getTerritoryState(index);
		}
		
		int currentIndex = 0;
		
		for(int i=0; i<this.territoryStates.getNumberOfTerritoryStates(); i++) {
			
			if(!this.territoryStates.getTerritoryState(i).isTemp()) {
				
				if(currentIndex == index) {
					
					return this.territoryStates.getTerritoryState(i);
				}
				
				currentIndex++;
			}
		}
		
		return null;
	}
	
	
	
	private final Observer territoryStatesObserver = new Observer() {
		
		@Override
		public void update() {
			
			fireContentsChanged(TerritoryStatesListModel.this, 0, TerritoryStatesListModel.this.getSize());
		}
	};
}
