package tdd.views;



import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import model.Territorium;
import tdd.controllers.TerritoryStateController;
import tdd.models.TerritoryState;
import tdd.models.TerritoryStateContainer;
import tdd.models.TerritoryStates;
import util.Observer;
import view.TerritoriumPanel;



public class TerritoryStatesBrowser extends JDialog {
	
	
	
	private static final long serialVersionUID = -8148284038783828505L;
	
	
	
	private JSplitPane splitPane;
	private TerritoryStatesListView territoryStatesListView;
	private TerritoryStateContainer territoryStateContainer = new TerritoryStateContainer();
	private JButton commit;
	private boolean commited = false;
	
	
	
	public TerritoryStatesBrowser(TerritoryStates territoryStates, final TerritoryStateController territoryStateController) {
	
		JPanel contentPane = new JPanel();
		contentPane.setLayout(new BorderLayout());
		
		this.splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		
		this.territoryStatesListView = new TerritoryStatesListView(territoryStates);
		this.territoryStatesListView.addListSelectionListener(this.territoryStatesListViewListSelectionListener);
		
		JScrollPane territoryStatesScrollPane = new JScrollPane(territoryStatesListView);
		splitPane.setLeftComponent(territoryStatesScrollPane);
		
		splitPane.setRightComponent(new JPanel());
		splitPane.setDividerLocation(200);
		splitPane.setResizeWeight(0.5);
		
		contentPane.add(splitPane, BorderLayout.CENTER);
		
		this.territoryStateContainer.addObserver(this.territoryStateContainerObserver);
		
		JPanel bottomPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		
		this.commit = new JButton("Übernehmen");
		this.commit.setEnabled(false);
		this.commit.addActionListener(this.commitActionListener);
		
		JButton abort = new JButton("Abbrechen");
		abort.addActionListener(this.abortActionListener);
		
		bottomPanel.add(this.commit);
		bottomPanel.add(abort);
		
		contentPane.add(bottomPanel, BorderLayout.SOUTH);
		
		this.setContentPane(contentPane);
		this.setModal(true);
		this.setModalityType(ModalityType.APPLICATION_MODAL);
		
		this.setSize(800, 600);
		this.setLocationRelativeTo(null);
	}
	
	
	
	public void setSelectedTerritoryState(TerritoryState territoryState) {
		
		if(territoryState != null) {
			
			this.territoryStatesListView.setSelectedValue(territoryState, true);
		}
	}
	
	public TerritoryState getSelectedTerritoryState() {
		
		return this.territoryStateContainer.getTerritoryState();
	}
	
	public boolean isCommited() {
		
		return this.commited;
	}
	
	
	
	private ActionListener commitActionListener = new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {
	
			commited = true;
			setVisible(false);
		}
	};
	
	private ActionListener abortActionListener = new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {
			
			setVisible(false);
		}
	};
	
	
	
	private final Observer territoryStateContainerObserver = new Observer() {
		
		@Override
		public void update() {
			
			TerritoryState territory = territoryStateContainer.getTerritoryState();
			commit.setEnabled(territory != null);
			
			if(territory != null) {
				
				Territorium t = new Territorium();
				t.setSize(territory.getNumberOfRows(), territory.getNumberOfColumns());
				t.clear();
				
				for(int i=0; i<t.getNumberOfRows(); i++) {
					
					for(int j=0; j<t.getNumberOfColumns(); j++) {
						
						t.setNoOfGrains(i, j, territory.getNumberOfGrainsOnTile(i, j));
						
						if(territory.isWallOnTile(i, j)) {
							
							t.setWall(i, j);
						}
					}
				}
				
			
				t.setHamsterOnTile(territory.getHamsterState().getRow(), territory.getHamsterState().getColumn());
				
				while(territory.getHamsterState().isDirectionNorth() && t.getHamsterDirection() != Territorium.NORD) {
					
					t.getHamster().linksUm();
				}
				
				while(territory.getHamsterState().isDirectionWest() && t.getHamsterDirection() != Territorium.WEST) {
							
					t.getHamster().linksUm();
				}
				
				while(territory.getHamsterState().isDirectionSouth() && t.getHamsterDirection() != Territorium.SUED) {
					
					t.getHamster().linksUm();
				}
				
				while(territory.getHamsterState().isDirectionEast() && t.getHamsterDirection() != Territorium.OST) {
					
					t.getHamster().linksUm();
				}
				
				while(t.getHamsterGrains() > territory.getHamsterState().getNumberOfGrains()) {
					
					int grains = t.getNoOfGrains(t.getHamsterRow(), t.getHamsterCol());
					t.getHamster().gib();
					t.setNoOfGrains(t.getHamsterRow(), t.getHamsterCol(), grains);
				}
				
				while(t.getHamsterGrains() < territory.getHamsterState().getNumberOfGrains()) {
					
					int grains = t.getNoOfGrains(t.getHamsterRow(), t.getHamsterCol());
					t.setNoOfGrains(t.getHamsterRow(), t.getHamsterCol(), grains + 1);
					t.getHamster().nimm();
				}
				
				
				TerritoriumPanel tp = new TerritoriumPanel(t);
				tp.setSize(1000, 1000);
				
				splitPane.setRightComponent(new JScrollPane(tp));
			}
		}
	};
	
	private final ListSelectionListener territoryStatesListViewListSelectionListener = new ListSelectionListener() {
		
		@Override
		public void valueChanged(ListSelectionEvent e) {
			
			TerritoryState territory = territoryStatesListView.getSelectedValue();
			territoryStateContainer.setTerritoryState(territory);
		}
	};
}
