package tdd.views;



import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import controller.TDDFrameworkContainer;
import tdd.TDDFramework;
import tdd.controllers.TerritoryStateController;
import tdd.models.TerritoryState;
import tdd.models.TerritoryStates;
import tdd.models.Test;
import util.ImageLoader;



public class TerritoryStateChooser extends JPanel {

	
	
	private static final long serialVersionUID = 369760227106864102L;

	
	
	private TerritoryStateController territoryStateController;
	private TerritoryStates territoryStates;
	private JTextField nameField;
	private Listener listener;
	private Test test;
	
	
	
	public TerritoryStateChooser(Test test, Listener listener, TerritoryStates territoryStates, TerritoryStateController territoryStateController) {
	
		this.territoryStateController = territoryStateController;
		this.territoryStates = territoryStates;
		this.listener = listener;
		this.test = test;
		
		this.nameField = new JTextField();
		this.nameField.getDocument().addDocumentListener(this.pathFieldDocumentListener);
		
		JButton chooseButton = new JButton("...");
		chooseButton.addActionListener(this.chooseButtonActionListener);
		chooseButton.setToolTipText("Territorium auswählen");
		
		JButton saveAndUseTerritory = new JButton();
		saveAndUseTerritory.setIcon(ImageLoader.getImageIcon("Camera16.png"));
		saveAndUseTerritory.addActionListener(this.saveAndUseTerritoryActionListener);
		saveAndUseTerritory.setToolTipText("derzeitiges Territorium übernehmen");
		
		JButton showTerritory = new JButton();
		showTerritory.setIcon(ImageLoader.getImageIcon("Eye16.png"));
		showTerritory.addActionListener(this.showTerritoryActionListener);
		showTerritory.setToolTipText("Territorium setzen");
		
		JPanel rightPanel = new JPanel(new FlowLayout());
		rightPanel.add(chooseButton);
		rightPanel.add(saveAndUseTerritory);
		rightPanel.add(showTerritory);
		

		this.setLayout(new BorderLayout());
		this.add(this.nameField, BorderLayout.CENTER);
		this.add(rightPanel, BorderLayout.EAST);
	}
	
	
	
	public String getFilename() {
		
		return this.nameField.getText();
	}
	
	public void setFilename(String filename) {
		
		this.nameField.setText(filename);
	}
	
	
	
	protected void onPathChanged() {
		
		if(this.listener != null) {
			
			this.listener.pathChanged();
		}
	}
	
	
	
	private final DocumentListener pathFieldDocumentListener = new DocumentListener() {
		
		@Override
		public void removeUpdate(DocumentEvent e) {
			
			onPathChanged();
		}
		
		@Override
		public void insertUpdate(DocumentEvent e) {

			onPathChanged();
		}
		
		@Override
		public void changedUpdate(DocumentEvent e) {

			onPathChanged();
		}
	};
	
	private final ActionListener chooseButtonActionListener = new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {
			
			TerritoryStatesBrowser statesBrowser = new TerritoryStatesBrowser(territoryStates, territoryStateController);
			
			if(territoryStates.exists(nameField.getText())) {
				
				statesBrowser.setSelectedTerritoryState(territoryStates.getTerritoryState(nameField.getText()));
			}
			
			statesBrowser.setVisible(true);
			
			if(statesBrowser.getSelectedTerritoryState() != null && statesBrowser.isCommited()) {
				
				TerritoryState state = territoryStates.getTerritoryState(nameField.getText());
				
				if(state != null && state.isTemp()) {
					
					territoryStateController.deleteTerritoryState(territoryStates.getTerritoryState(nameField.getText()));
				}
				
				nameField.setText(statesBrowser.getSelectedTerritoryState().getName());
			}
			
			/*
			JFileChooser fileChooser = new JFileChooser(new File(""));
	
	        if (fileChooser.showOpenDialog(FilePathChooser.this) == JFileChooser.APPROVE_OPTION) {
	        	
	            File file = fileChooser.getSelectedFile();
            	pathField.setText(file.getAbsolutePath());
	        }*/
		}
	};
	
	private final ActionListener showTerritoryActionListener = new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {
			
			String name = nameField.getText();
			
			if(name != null && name.length() > 0) {
				
				TDDFramework framework = TDDFrameworkContainer.getTDDFramework();
				
				if(framework.getTerritoryStates().exists(name)) {
					
					TerritoryState state = framework.getTerritoryStates().getTerritoryState(name);
					
					framework.getTerritoryStateController().setCurrentTerritoryState(state);
				}
			}
		}
	};
	
	private final ActionListener saveAndUseTerritoryActionListener = new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {
			
			TerritoryState state = territoryStates.getTerritoryState(nameField.getText());
			
			if(state != null && state.isTemp()) {
				
				territoryStateController.deleteTerritoryState(territoryStates.getTerritoryState(nameField.getText()));
			}
			
			String name = territoryStateController.saveTempTerritoryState(test.getFullName(" "), null);
			nameField.setText(name);
		}
	};
	
	
	
	public interface Listener {
		
		public void pathChanged();
	}
}
