package tdd.views;



import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import tdd.controllers.TerritoryStateController;
import tdd.interfaces.SimulationState;
import tdd.models.TerritorySequenceTestContent;
import tdd.models.TerritoryStates;



public class TerritorySequenceTestContentView extends JPanel {

	

	private static final long serialVersionUID = -5799629550155148733L;
	
	
	
	private TerritorySequenceTestContent territorySequence;
	
	private JTextField methodCallField;
	private TerritoryStateChooser startStateFilePath;
	
	
	
	public TerritorySequenceTestContentView(
			TerritorySequenceTestContent value, 
			TerritoryStates territoryStates, 
			TerritoryStateController territoryStateController,
			SimulationState simulationState) {
		
		
		this.setLayout(new BorderLayout());
		
		JPanel content = new JPanel();
		content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
		
		JLabel startStateFilePathLabel = new JLabel("Start-Territorium angeben:");
		startStateFilePathLabel.setAlignmentX(Component.LEFT_ALIGNMENT);
		content.add(startStateFilePathLabel);
		
		this.startStateFilePath = new TerritoryStateChooser(value.getTest(), this.startStateFilePathListener, territoryStates, territoryStateController);
		startStateFilePath.setAlignmentX(Component.LEFT_ALIGNMENT);
		content.add(startStateFilePath);
		content.add(Box.createVerticalStrut(20));
		
		JLabel methodCallFieldLabel = new JLabel("Methodenaufruf:");
		methodCallFieldLabel.setAlignmentX(Component.LEFT_ALIGNMENT);
		content.add(methodCallFieldLabel);
		
		this.methodCallField = new JTextField();
		this.methodCallField.getDocument().addDocumentListener(this.methodCallFieldDocumentListener);
		methodCallField.setAlignmentX(Component.LEFT_ALIGNMENT);
		content.add(methodCallField);
		content.add(Box.createVerticalStrut(20));

		JLabel squenceLabel = new JLabel("Folge:");
		squenceLabel.setAlignmentX(Component.LEFT_ALIGNMENT);
		content.add(squenceLabel);
		
		
		EditTeritoryStatesView editTerritoryStatesView = new EditTeritoryStatesView(
				territoryStateController, 
				value.getTest(), 
				value.getTerritoryStates(),
				simulationState
			);
		
		editTerritoryStatesView.setAlignmentX(Component.LEFT_ALIGNMENT);
		
		content.add(editTerritoryStatesView);
		
		
		this.add(content, BorderLayout.NORTH);
		
		this.territorySequence = value;
		this.update();
	}
	
	
	
	private void update() {
		
		this.startStateFilePath.setFilename(territorySequence.getStartTerritory());
		this.methodCallField.setText(territorySequence.getMethodCall());
	}
	
	
	
	private final TerritoryStateChooser.Listener startStateFilePathListener = new TerritoryStateChooser.Listener() {
		
		@Override
		public void pathChanged() {
			
			territorySequence.setStartTerritory(startStateFilePath.getFilename());
		}
	};
	
	private final DocumentListener methodCallFieldDocumentListener = new DocumentListener() {
		
		@Override
		public void removeUpdate(DocumentEvent e) {
			
			territorySequence.setMethodCall(methodCallField.getText());
		}
		
		@Override
		public void insertUpdate(DocumentEvent e) {

			territorySequence.setMethodCall(methodCallField.getText());
		}
		
		@Override
		public void changedUpdate(DocumentEvent e) {

			territorySequence.setMethodCall(methodCallField.getText());
		}
	};
}
