package tdd.views;



import java.awt.BorderLayout;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

import tdd.TDDFramework;
import tdd.models.TestContentViewContainer;
import util.Observer;



public class TDDPanel extends JSplitPane {

	
	
	private static final long serialVersionUID = -4247386182267545443L;
	
	
	
	private JSplitPane topPane;
	private TestContentViewContainer testContentViewContainer;
	
	
	
	public TDDPanel(TDDFramework tddFramework) {
		
		super(JSplitPane.VERTICAL_SPLIT);
		
		this.init(tddFramework);
		
		this.testContentViewContainer = tddFramework.getTestContentViewContainer();
		this.testContentViewContainer.addObserver(this.testContentViewContainerObserver);
		
		this.update();
	}
	
	
	
	public TestContentViewContainer getTestContentViewContainer() {
		
		return this.testContentViewContainer;
	}
	
	
	
	private void init(TDDFramework tddFramework) {

		this.topPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		this.topPane.setResizeWeight(.25d);
		this.topPane.setOneTouchExpandable(true);
		
		TestsuiteTreeView testsuiteTreeView = new TestsuiteTreeView(
				tddFramework.getTestsuiteController(), 
				tddFramework.getTestRunner(), 
				tddFramework.getTestsuiteContainer()
			);
		
		JScrollPane testsuiteTreeViewScrollPane = new JScrollPane(testsuiteTreeView);
		this.topPane.setLeftComponent(testsuiteTreeViewScrollPane);
	
		this.setTopComponent(this.topPane);
		
		//TODO hier noch anpassen
		
		TestRunnerInformationTable table = new TestRunnerInformationTable(tddFramework.getTestRunnerInformation());
		JScrollPane scrollPane = new JScrollPane(table);
		
		JPanel bottomPanel = new JPanel(new BorderLayout());
		bottomPanel.add(new TestRunnerInformationPanel(tddFramework.getTestRunnerInformation()), BorderLayout.NORTH);
		bottomPanel.add(scrollPane, BorderLayout.CENTER);
		
		this.setBottomComponent(bottomPanel);
		//-------------------
		
		
		this.setOneTouchExpandable(true);
		this.setResizeWeight(.75d);
	}
	
	
	
	private void update() {
		
		JComponent component = this.getTestContentViewContainer().getTestContentView();
		
		JScrollPane componentScrollPane = new JScrollPane(component);
		this.topPane.setRightComponent(componentScrollPane);
	}
	
	
	
	private final Observer testContentViewContainerObserver = new Observer() {
		
		@Override
		public void update() {
			
			TDDPanel.this.update();
		}
	};
}
