package tdd.views;



import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import tdd.controllers.TerritoryStateController;
import tdd.models.FinalStateTestContent;
import tdd.models.TerritoryStates;



public class FinalStateTestContentView extends JPanel {

	

	private static final long serialVersionUID = -5799629550155148733L;
	
	
	
	private FinalStateTestContent finalStateTestContent;
	
	private TerritoryStateChooser startStateFilePath;
	private JTextField methodCallField;
	private TerritoryStateChooser endStateFilePath;
	
	
	
	public FinalStateTestContentView(FinalStateTestContent finalStateTestContent, TerritoryStates territoryStates, TerritoryStateController territoryStateController) {
		
		this.setLayout(new BorderLayout());
		
		JPanel content = new JPanel();
		content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
		
		JLabel startStateFilePathLabel = new JLabel("Start-Territorium angeben:");
		startStateFilePathLabel.setAlignmentX(Component.LEFT_ALIGNMENT);
		content.add(startStateFilePathLabel);
		
		this.startStateFilePath = new TerritoryStateChooser(finalStateTestContent.getTest(), this.startStateFilePathListener, territoryStates, territoryStateController);
		startStateFilePath.setAlignmentX(Component.LEFT_ALIGNMENT);
		content.add(startStateFilePath);
		content.add(Box.createVerticalStrut(20));
		
		JLabel methodCallFieldLabel = new JLabel("Methodenaufruf:");
		content.add(methodCallFieldLabel);
		
		this.methodCallField = new JTextField();
		this.methodCallField.getDocument().addDocumentListener(this.methodCallFieldDocumentListener);
		methodCallField.setAlignmentX(Component.LEFT_ALIGNMENT);
		content.add(methodCallField);
		content.add(Box.createVerticalStrut(20));
		
		JLabel endStateFilePathLabel = new JLabel("End-Territorium angeben:");
		endStateFilePathLabel.setAlignmentX(Component.LEFT_ALIGNMENT);
		content.add(endStateFilePathLabel);
		
		this.endStateFilePath = new TerritoryStateChooser(finalStateTestContent.getTest(), this.endStateFilePathListener, territoryStates, territoryStateController);
		endStateFilePath.setAlignmentX(Component.LEFT_ALIGNMENT);
		content.add(endStateFilePath);
		
		this.add(content, BorderLayout.NORTH);
		
		this.finalStateTestContent = finalStateTestContent;
		
		this.update();
	}
	
	
	
	public FinalStateTestContent getFinalStateTestContent() {
		
		return this.finalStateTestContent;
	}
	
	
	
	private void update() {
		
		this.startStateFilePath.setFilename(this.getFinalStateTestContent().getStartStateFilename());
		this.methodCallField.setText(this.getFinalStateTestContent().getMethodCall());
		this.endStateFilePath.setFilename(this.getFinalStateTestContent().getEndStateFilename());
	}
	
	
	
	private final TerritoryStateChooser.Listener startStateFilePathListener = new TerritoryStateChooser.Listener() {
		
		@Override
		public void pathChanged() {
			
			getFinalStateTestContent().setStartStateFilename(startStateFilePath.getFilename());
		}
	};
	
	private final DocumentListener methodCallFieldDocumentListener = new DocumentListener() {
		
		@Override
		public void removeUpdate(DocumentEvent e) {
			
			getFinalStateTestContent().setMethodCall(methodCallField.getText());
		}
		
		@Override
		public void insertUpdate(DocumentEvent e) {

			getFinalStateTestContent().setMethodCall(methodCallField.getText());
		}
		
		@Override
		public void changedUpdate(DocumentEvent e) {

			getFinalStateTestContent().setMethodCall(methodCallField.getText());
		}
	};
	
	private final TerritoryStateChooser.Listener endStateFilePathListener = new TerritoryStateChooser.Listener() {
		
		@Override
		public void pathChanged() {
			
			getFinalStateTestContent().setEndStateFilename(endStateFilePath.getFilename());
		}
	};
}
