package tdd.views;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import controller.territory.TerritoryManager;
import tdd.controllers.TerritoryStateController;
import tdd.interfaces.SimulationState;
import tdd.models.TerritoryState;
import tdd.models.TerritoryStateContainer;
import tdd.models.TerritoryStates;
import tdd.models.Test;
import util.ImageLoader;
import util.Observer;

public class EditTeritoryStatesView extends JPanel {

	private static final long serialVersionUID = 2900797457752656418L;

	private TerritoryStateContainer territoryStateContainer = new TerritoryStateContainer();
	private Test test;
	private TerritoryStates territoryStates;
	private SimulationState simulationState;
	
	private TerritoryStateController territoryStateController;
	
	private JButton deleteButton;
	private JButton moveUp;
	private JButton moveDown;
	private JButton addButton;
	private JButton addTempButton;
	private JToggleButton recordButton;
	private JToggleButton showButton;
	private TerritoryStatesListView territoryStatesListView;
	
	public EditTeritoryStatesView(TerritoryStateController territoryStateController, Test test, TerritoryStates territoryStates, SimulationState simulationState) {
		
		this.test = test;
		this.territoryStates = territoryStates;
		this.simulationState = simulationState;
		
		this.territoryStateController = territoryStateController;
		
		this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		
		JPanel controlPanel = new JPanel(new FlowLayout());
		controlPanel.setAlignmentX(Component.LEFT_ALIGNMENT);
		this.add(controlPanel);
		
		
		this.deleteButton = new JButton("-");
		this.deleteButton.addActionListener(this.deleteActionListener);
		this.deleteButton.setEnabled(false);
		this.deleteButton.setToolTipText("ausgewähltes Territorium entfernen");
		controlPanel.add(this.deleteButton);
		
		this.moveUp = new JButton();
		this.moveUp.setIcon(ImageLoader.getImageIcon("Up16.png"));
		this.moveUp.addActionListener(this.moveUpActionListener);
		this.moveUp.setToolTipText("ausgewähltes Territorium nach oben schieben");
		controlPanel.add(this.moveUp);
		
		this.moveDown = new JButton();
		this.moveDown.setIcon(ImageLoader.getImageIcon("Down16.png"));
		this.moveDown.addActionListener(this.moveDownActionListener);
		this.moveDown.setToolTipText("ausgewähltes Territorium nach unten schieben");
		controlPanel.add(this.moveDown);
		
		this.addButton = new JButton("+");
		this.addButton.addActionListener(this.addActionListener);
		this.addButton.setToolTipText("Territorium auswählen und hinzufügen");
		controlPanel.add(this.addButton);
		
		this.addTempButton = new JButton();
		this.addTempButton.setIcon(ImageLoader.getImageIcon("Camera16.png"));
		this.addTempButton.addActionListener(this.addTempActionListener);
		this.addTempButton.setToolTipText("derzeitiges Territorium hinzufügen");
		controlPanel.add(this.addTempButton);
		
		this.recordButton = new JToggleButton();
		this.recordButton.setIcon(ImageLoader.getImageIcon("Record16.gif"));
		this.recordButton.addActionListener(this.recordActionListener);
		this.recordButton.setToolTipText("Territorium aufzeichnen und automatisch hinzufügen");
		controlPanel.add(this.recordButton);
		
		this.showButton = new JToggleButton();
		this.showButton.setIcon(ImageLoader.getImageIcon("Eye16.png"));
		this.showButton.addActionListener(this.showActionListener);
		this.showButton.setToolTipText("selektiertes Territorium setzen");
		controlPanel.add(this.showButton);
		
		this.territoryStatesListView = new TerritoryStatesListView(territoryStates, true);
		this.territoryStatesListView.addListSelectionListener(territoryStatesListViewListSelectionListener);
		
		JScrollPane territoryStatesListViewScrollPane = new JScrollPane(this.territoryStatesListView);
		territoryStatesListViewScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
		this.add(territoryStatesListViewScrollPane);
		
		
		this.territoryStateContainer.addObserver(this.territoryStateContainerObserver);
		this.simulationState.addObserver(this.simulationStateObserver);
	}
	
	
	
	private void updateSelection() {
		
		showButton.setEnabled(territoryStateContainer.getTerritoryState() != null);
		
		if(showButton.isSelected() && territoryStateContainer.getTerritoryState() == null) {
			
			showButton.setSelected(false);
		}
		
		if(territoryStatesListView.getSelectedIndex() < territoryStates.getNumberOfTerritoryStates()) {
			
			territoryStateContainer.setTerritoryState(territoryStatesListView.getSelectedValue());
			deleteButton.setEnabled(territoryStatesListView.getSelectedValue() != null);
			
		} else {
			
			deleteButton.setEnabled(false);
		}
	}
	
	
	
	private final ActionListener moveUpActionListener = new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {
			
			territoryStates.moveUp(territoryStateContainer.getTerritoryState());
			territoryStatesListView.setSelectedValue(territoryStateContainer.getTerritoryState(), true);
		}
	};
	
	private final ActionListener moveDownActionListener = new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {

			territoryStates.moveDown(territoryStateContainer.getTerritoryState());
			territoryStatesListView.setSelectedValue(territoryStateContainer.getTerritoryState(), true);
		}
	};
	
	private Observer simulationStateObserver = new Observer() {
		
		@Override
		public void update() {
			
			if(simulationState.isRunning()) {
				
				recordButton.setEnabled(false);
				showButton.setEnabled(false);
				
				if(recordButton.isSelected()) {
					
					territoryStateContainer.deleteObserver(showTerritoryStateObserver);
					recordButton.setSelected(false);
					TerritoryManager.getTerritoryManager().getTerritorium().getHamster().deleteObserver(hamsterObserver);
				}
				
				if(showButton.isSelected()) {
					
					territoryStateContainer.deleteObserver(showTerritoryStateObserver);
					showButton.setSelected(false);
					TerritoryManager.getTerritoryManager().getTerritorium().getHamster().deleteObserver(hamsterObserver);
				}
				
			} else {
				
				recordButton.setEnabled(true);
				showButton.setEnabled(true);
			}
		}
	};
	
	private Observer territoryStateContainerObserver = new Observer() {
		
		@Override
		public void update() {
			
			updateSelection();
		}
	};
	
	private final ListSelectionListener territoryStatesListViewListSelectionListener = new ListSelectionListener() {
		
		@Override
		public void valueChanged(ListSelectionEvent e) {
			
			TerritoryState territory = territoryStatesListView.getSelectedValue();
			territoryStateContainer.setTerritoryState(territory);
		}
	};
	
	private ActionListener showActionListener = new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {
			
			if(showButton.isSelected()) {
				
				TerritoryManager.getTerritoryManager().getTerritorium().getHamster().deleteObserver(hamsterObserver);
				recordButton.setSelected(false);
				territoryStateContainer.addObserver(showTerritoryStateObserver);
				
				if(territoryStateContainer.getTerritoryState() != null) {
					
					territoryStateController.getStateManager().setTerritoryState(territoryStateContainer.getTerritoryState());
				}
				
			} else {
				
				territoryStateContainer.deleteObserver(showTerritoryStateObserver);
			}
		}
	};
	
	private ActionListener recordActionListener = new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {
			
			if(recordButton.isSelected()) {
				
				territoryStateContainer.deleteObserver(showTerritoryStateObserver);
				showButton.setSelected(false);
				TerritoryManager.getTerritoryManager().getTerritorium().getHamster().addObserver(hamsterObserver);
				
			} else {
				
				TerritoryManager.getTerritoryManager().getTerritorium().getHamster().deleteObserver(hamsterObserver);
			}
		}
	};
	
	private Observer hamsterObserver = new Observer() {
		
		@Override
		public void update() {

			territoryStateController.saveTempTerritoryState(test.getFullName(" "), territoryStates);
			updateSelection();
		}
	};
	
	private Observer showTerritoryStateObserver = new Observer() {
		
		@Override
		public void update() {
			
			territoryStateController.setCurrentTerritoryState(territoryStateContainer.getTerritoryState());
		}
	};
	
	private ActionListener addTempActionListener = new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {
			
			territoryStateController.saveTempTerritoryState(test.getFullName(" "), territoryStates);
			updateSelection();
		}
	};
	
	private ActionListener addActionListener = new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {
			
			TerritoryStatesBrowser statesBrowser = new TerritoryStatesBrowser(territoryStateController.getTerritoryStates(), territoryStateController);
			statesBrowser.setVisible(true);
			
			if(statesBrowser.getSelectedTerritoryState() != null && statesBrowser.isCommited()) {
				
				territoryStates.add(statesBrowser.getSelectedTerritoryState());
				updateSelection();
			}
		}
	};
	
	private final ActionListener deleteActionListener = new ActionListener() {
		
		@Override
		public void actionPerformed(ActionEvent e) {
			
			TerritoryState state = territoryStateContainer.getTerritoryState();
			
			if(state != null && state.isTemp()) {
				
				territoryStateController.deleteTerritoryState(state);
			}
			
			territoryStates.remove(state);
			updateSelection();
		}
	};
}
