package tdd.views;



import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.Objects;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;

import tdd.models.CustomTestContent;



public class CustomTestContentView extends RSyntaxTextArea {

	

	private static final long serialVersionUID = -5799629550155148733L;
	
	
	
	private final Color editorColor = new Color(170, 255, 190);

	
	
	private CustomTestContent customTestContent;
	
	
	
	public CustomTestContentView(CustomTestContent customTestContent) {
		
		this.setBackground(this.editorColor);
		this.setFocusable(true);
		this.setFont(new Font(Font.MONOSPACED, Font.PLAIN, 12));
		this.setMargin(new Insets(5, 5, 5, 5));
		this.setEditable(true);
		this.setLineWrap(false);
		this.setSyntaxEditingStyle(SyntaxConstants.SYNTAX_STYLE_JAVA);
		this.setCodeFoldingEnabled(true);
		
		this.getDocument().addDocumentListener(this.documentListener);
		
		this.customTestContent = customTestContent;

		this.update();
	}
	
	
	
	public CustomTestContent getCustomTestContent() {
		
		return this.customTestContent;
	}
	
	
	
	private void update() {
		
		String code = this.getCustomTestContent().getUserCode();
		
		if(!Objects.equals(code, this.getText())) {
			
			this.setText(code);
		}
	}
	
	
	
	private final DocumentListener documentListener = new DocumentListener() {
		
		@Override
		public void removeUpdate(DocumentEvent e) {
			
			this.updateCustomTestContent();
		}
		
		@Override
		public void insertUpdate(DocumentEvent e) {
			
			this.updateCustomTestContent();
		}
		
		@Override
		public void changedUpdate(DocumentEvent e) {
			
			this.updateCustomTestContent();
		}
		
		private void updateCustomTestContent() {
			
			CustomTestContent content = CustomTestContentView.this.getCustomTestContent();
			content.setUserCode(CustomTestContentView.this.getText());
		}
	};
}
