package tdd.views;



import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;



public abstract class AbstractTestsuiteTreeNode {

	
	
	private Object value;
	private AbstractTestsuiteTreeNode parent;
	private TestsuiteTreeModel testsuiteTreeModel;
	private List<AbstractTestsuiteTreeNode> childs = new ArrayList<AbstractTestsuiteTreeNode>();
	
	
	
	public AbstractTestsuiteTreeNode(TestsuiteTreeModel testsuiteTreeModel, AbstractTestsuiteTreeNode parent, Object value) {
	
		this.testsuiteTreeModel = testsuiteTreeModel;
		this.parent = parent;
		this.value = value;
	}
	
	
	
	public TestsuiteTreeModel getTestsuiteTreeModel() {
		
		return this.testsuiteTreeModel;
	}
	
	public Object getValue() {
		
		return this.value;
	}
	
	public AbstractTestsuiteTreeNode getParent() {
		
		return this.parent;
	}
	
	
	
	protected void add(AbstractTestsuiteTreeNode child) {
		
		int index = this.childs.size();
		this.childs.add(child);
		
		this.getTestsuiteTreeModel().inserted(this.getPath(), new int[] {index}, new AbstractTestsuiteTreeNode[] {child});
	}
	
	protected void remove(AbstractTestsuiteTreeNode child) {
		
		int index = this.getIndexOfChild(child);
		this.childs.remove(child);
		
		this.getTestsuiteTreeModel().removed(this.getPath(), new int[] {index}, new AbstractTestsuiteTreeNode[] {child});
	}
	
	public int getLevel() {
		
		int level = 0;
		
		AbstractTestsuiteTreeNode parent = this.getParent();
		
		while(parent != null) {
			
			level++;
			parent = parent.getParent();
		}
		
		return level;
	}
	
	public boolean isNodeChild(AbstractTestsuiteTreeNode node) {
		
		return this.childs.contains(node);
	}
	
	public AbstractTestsuiteTreeNode get(int index) {
		
		return this.childs.get(index);
	}
	
	public int getNumberOfChilds() {
		
		return this.childs.size();
	}
	
	public int getIndexOfChild(AbstractTestsuiteTreeNode child) {
		
		return this.childs.indexOf(child);
	} 
	
	public boolean contains(AbstractTestsuiteTreeNode child) {
		
		return this.childs.contains(child);
	}
	
	public boolean contains(Object childValue) {
		
		for(AbstractTestsuiteTreeNode node : this.childs) {
			
			if(Objects.equals(node.getValue(), childValue)) {
				
				return true;
			}
		}
		
		return false;
	}
	
	public AbstractTestsuiteTreeNode[] getChilds() {
		
		return this.childs.toArray(new AbstractTestsuiteTreeNode[this.childs.size()]);
	}
	
	public AbstractTestsuiteTreeNode[] getPath() {
		
		List<AbstractTestsuiteTreeNode> path = new ArrayList<AbstractTestsuiteTreeNode>();
		AbstractTestsuiteTreeNode parent = this;
		
		while(parent != null) {
			
			path.add(parent);
			parent = parent.getParent();
		}
		
		Collections.reverse(path);
		
		return path.toArray(new AbstractTestsuiteTreeNode[path.size()]);
	}
	
	
	
	@Override
	public String toString() {

		return this.value.toString();
	}
}
