package tdd.utils;



import java.util.HashMap;
import java.util.Map;



public class ViewChooser<TBaseView> {

	
	
	private Map<Class<?>, ViewFactory<TBaseView>> mapping = new HashMap<Class<?>, ViewFactory<TBaseView>>();
	
	
	
	public void map(Class<?> cls, ViewFactory<TBaseView> factory) {
		
		this.mapping.put(cls, factory);
	}
	
	public void remove(Class<?> cls) {
		
		this.mapping.remove(cls);
	}
	
	
	
	public TBaseView create(Object value) {
		
		if(value == null) return null;
		
		ViewFactory<TBaseView> factory = this.getBestFactory(value);
		
		if(factory != null) return factory.create(value);
		
		return null;
	}
	
	private ViewFactory<TBaseView> getBestFactory(Object value) {
		
		return this.getBestFactory(value.getClass());
	}
	
	private ViewFactory<TBaseView> getBestFactory(Class<?> cls) {
		
		if(cls == null) return null;
		
		if(this.mapping.containsKey(cls)) {
			
			return this.mapping.get(cls);
			
		} else {
			
			return this.getBestFactory(cls.getSuperclass());
		}
	}
}
