package tdd.utils;



import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;



public class Streams {

	
	
	public static InputStream fromResources(String path) {
		
		ClassLoader loader = Streams.class.getClassLoader();
		return loader.getResourceAsStream(path);
	}
	
	public static String readComplete(InputStream inputStream) throws IOException {
		
		try {
			
			InputStreamReader reader = new InputStreamReader(inputStream);
			char[] buffer = new char[1024];
			StringBuilder builder = new StringBuilder();
			int readed = 0;
			
			while((readed = reader.read(buffer, 0, buffer.length)) > 0) {
				
				for(int i=0; i<readed; i++) {
					
					builder.append(buffer[i]);
				}
			}
			
			return builder.toString();
			
		} catch (IOException e) {
			
			throw e;
			
		} finally {
			
			if(inputStream != null) {
				
				try {
					
					inputStream.close();
					
				} catch (Exception e2) {}
			}
		}
	}
}
