package tdd.utils;



import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;



public class Files {

	
	
	public static String getNameWithoutSUffix(File file) {
		
		String name = file.getName();
		String[] splittedName = name.split(".");
		
		if(splittedName.length > 0) {
			
			return splittedName[0];
		}
		
		return name;
	}
	
	public static void delete(File file) {
		
		if(file.isDirectory()) {
			
			for(File f : file.listFiles()) {
				
				Files.delete(f);
			}
			
			file.delete();
			
		} else {
			
			file.delete();
		}
	}
	
	public static String readComplete(File file) throws IOException {
		
		FileInputStream fis = null;
		
		try {
			
			fis = new FileInputStream(file);
			byte[] data = new byte[(int) file.length()];
			fis.read(data);
			
			return new String(data, "UTF-8");
			
		} catch (IOException e) {
			
			throw e;
			
		} finally {
			
			if(fis != null) {
				
				try {
					
					fis.close();
					
				} catch (Exception e2) {}
			}
		}
	}
}
