


import tdd.annotations.Test;
import tdd.annotations.Einrichtung;
import tdd.models.TerritoryStates;
import tdd.controllers.TerritoryStateController;
import tdd.errors.TerritoriumErreichtErwartungError;
import tdd.errors.KeinTerritoriumErwartetError;
import tdd.errors.TerritoriumGleichErwartungError;
import tdd.errors.BlacklistTerritoriumError;
import util.Observer;



public class <TestName> extends BaseTest {
	
	
	
	private int counter = 0;
	private String[] territories = new String[<TerritoriesLength>];
	private String[] blacklist = new String[<BlacklistLength>];
	
	
	
	public <TestName>(TerritoryStateController territoryStateController) {
	
		super(territoryStateController);
				
		<InitializeTerritories>
		
		<InitializeBlacklist>
	}
	
	
	
	@Einrichtung()
	public void setup() {
	
		ladeTerritorium("<StartStateFile>");
		
		this.addObserver(this.hamsterObserver);
	}
	
	@Test()
	public void testeTerritoriumCheckpoints() {

		try {
		
			<MethodCall>
		
		} catch(Exception e) {

			throw e;
			
		} finally {
		
			this.deleteObserver(this.hamsterObserver);
		}
	
		if(counter != territories.length) {
		
			throw new TerritoriumErreichtErwartungError();
		}
	}
	
	
	
	private void testeNaechstesTerritorium() {
	
		if(counter < territories.length) {
			
			try {
			
				erwarteTerritoriumGleich(territories[counter]);
				counter++;
			
			} catch (TerritoriumGleichErwartungError e) {}
		}
	}
	
	private void testeBlacklist() {
	
		for(int i=0; i<blacklist.length; i++) {
		
			try {
		
				erwarteTerritoriumGleich(blacklist[i]);
				
				throw new BlacklistTerritoriumError(blacklist[i]);
			
			} catch (TerritoriumGleichErwartungError e) {}
		}
	}
	
	private final Observer hamsterObserver = new Observer() {
	
		public void update() {
		
			testeNaechstesTerritorium();
			testeBlacklist();
		}
	};
}