package tdd.templates;



import java.io.IOException;
import java.io.InputStream;

import tdd.models.Template;
import tdd.utils.Streams;



public class Templates {

	
	
	public static Template create(InputStream stream) throws IOException {
		
		return new Template(Streams.readComplete(stream));
	}
	
	
	
	public static class BaseTest {
		
		public static final String PATH = "tdd/templates/BaseTest.tpl";

		public static final String VARIABLE_PROGRAM_NAME = "ProgramName";
	}
	
	public static class CustomTestClass {
		
		public static final String PATH = "tdd/templates/CustomTestClass.tpl";
		
		public static final String VARIABLE_TEST_NAME = "TestName";
		public static final String VARIABLE_CONTENT = "Content";
	}
	
	public static class FinalStateTestClass {
		
		public static final String PATH = "tdd/templates/FinalStateTestClass.tpl";
		
		public static final String VARIABLE_TEST_NAME = "TestName";
		public static final String VARIABLE_START_STATE_FILE = "StartStateFile";
		public static final String VARIABLE_METHOD_CALL = "MethodCall";
		public static final String VARIABLE_END_STATE_FILE = "EndStateFile";
	}
	
	public static class MethodCallAssert {
		
		public static final String PATH = "tdd/templates/MethodCallAssert.tpl";
		
		public static final String VARIABLE_METHOD_CALL = "MethodCall";
	}
	
	public static class TerritorySequenceTestClass {
		
		public static final String PATH = "tdd/templates/TerritorySequenceTestClass.tpl";
		
		public static final String VARIABLE_TEST_NAME = "TestName";
		public static final String VARIABLE_START_STATE_FILE = "StartStateFile";
		public static final String VARIABLE_METHOD_CALL = "MethodCall";
		public static final String VARIABLE_TERRITORIES_LENGTH = "TerritoriesLength";
		public static final String VARIABLE_INITIALIZE_TERRITORIES = "InitializeTerritories";
	}
	
	public static class TerritoryCheckpointTestClass {
		
		public static final String PATH = "tdd/templates/TerritoryCheckpointTestClass.tpl";
		
		public static final String VARIABLE_TEST_NAME = "TestName";
		public static final String VARIABLE_START_STATE_FILE = "StartStateFile";
		public static final String VARIABLE_METHOD_CALL = "MethodCall";
		public static final String VARIABLE_TERRITORIES_LENGTH = "TerritoriesLength";
		public static final String VARIABLE_INITIALIZE_TERRITORIES = "InitializeTerritories";
		public static final String VARIABLE_BLACKLIST_LENGTH = "BlacklistLength";
		public static final String VARIABLE_INITIALIZE_BLACKLIST = "InitializeBlacklist";
	}
	
	public static class InitializeTerritory {
		
		public static final String PATH = "tdd/templates/InitializeTerritory.tpl";
		
		public static final String VARIABLE_INDEX = "Index";
		public static final String VARIABLE_TERRITORY_NAME = "TerritoryName";
	}
	
	public static class InitializeBlacklist {
		
		public static final String PATH = "tdd/templates/InitializeBlacklist.tpl";
		
		public static final String VARIABLE_INDEX = "Index";
		public static final String VARIABLE_TERRITORY_NAME = "TerritoryName";
	}
}
