


import java.lang.reflect.Method;
import tdd.interfaces.ITerritory;
import tdd.annotations.Einrichtung;
import tdd.annotations.Test;
import tdd.controllers.TerritoryStateController;



public class BaseTest extends <ProgramName> {
	
	
	
	private TerritoryStateController territoryStateController;
	
	
	
	public BaseTest(TerritoryStateController territoryStateController) {
	
		this.territoryStateController = territoryStateController;
	}
	
	
	
	public final void runSetupMethod(Method method) throws Throwable {
		
		if(method.getAnnotation(Einrichtung.class) != null) {
		
			method.invoke(this);
		}
	}
	
	public final void runTestCaseMethod(Method method) throws Throwable {
	
		if(method.getAnnotation(Test.class) != null) {
		
			method.invoke(this);
		}
	}
	
	
	
	final void ladeTerritorium(String name) {
	
		this.territoryStateController.setCurrentTerritoryState(name);
		this.notifyObservers();
	}
	
	final void erwarteTerritoriumGleich(String name) {
	
		ITerritory assertState = this.territoryStateController.getTerritoryState(name);
		
		this.erwarteTerritoriumGleich(assertState);
	}
	
	final void erwarteTerritoriumGleich(String text, String name) {
	
		ITerritory assertState = this.territoryStateController.getTerritoryState(name);
		
		this.erwarteTerritoriumGleich(text, assertState);
	}
	
	final void erwarteTerritoriumGleich(ITerritory assertState) {
	
		ITerritory currentState = this.territoryStateController.getStateManager().getTerritoryState();

		tdd.HamsterErwartungen.erwarteGleich(assertState, currentState);
	}
	
	final void erwarteTerritoriumGleich(String text, ITerritory assertState) {
	
		ITerritory currentState = this.territoryStateController.getStateManager().getTerritoryState();

		tdd.HamsterErwartungen.erwarteGleich(text, assertState, currentState);
	}
	
	final void erwarteReiheGleich(int reihe) {
	
		this.erwarteReiheGleich(null, reihe);
	}
	
	final void erwarteReiheGleich(String text, int reihe) {
	
		tdd.HamsterErwartungen.erwarteReiheGleich(text, this, reihe);
	}
	
	final void erwarteReiheUngleich(int reihe) {
	
		this.erwarteReiheUngleich(null, reihe);
	}
	
	final void erwarteReiheUngleich(String text, int reihe) {
	
		tdd.HamsterErwartungen.erwarteReiheUngleich(text, this, reihe);
	}
	
	
	final void erwarteSpalteGleich(int spalte) {
	
		this.erwarteSpalteGleich(null, spalte);
	}
	
	final void erwarteSpalteGleich(String text, int spalte) {
	
		tdd.HamsterErwartungen.erwarteSpalteGleich(text, this, spalte);
	}
	
	final void erwarteSpalteUngleich(int spalte) {
	
		this.erwarteSpalteUngleich(null, spalte);
	}
	
	final void erwarteSpalteUngleich(String text, int spalte) {
	
		tdd.HamsterErwartungen.erwarteSpalteUngleich(text, this, spalte);
	}
	
	
	final void erwartePositionGleich(int reihe, int spalte) {
	
		this.erwartePositionGleich(null, reihe, spalte);
	}
	
	final void erwartePositionGleich(String text, int reihe, int spalte) {
	
		tdd.HamsterErwartungen.erwartePositionGleich(text, this, reihe, spalte);
	}
	
	final void erwartePositionUngleich(int reihe, int spalte) {
	
		this.erwartePositionUngleich(null, reihe, spalte);
	}
	
	final void erwartePositionUngleich(String text, int reihe, int spalte) {
	
		tdd.HamsterErwartungen.erwartePositionUngleich(text, this, reihe, spalte);
	}
	
	
	final void erwarteAnzahlKoernerImMaulGleich(int anzahl) {
	
		this.erwarteAnzahlKoernerImMaulGleich(null, anzahl);
	}
	
	final void erwarteAnzahlKoernerImMaulGleich(String text, int anzahl) {
	
		tdd.HamsterErwartungen.erwarteAnzahlKoernerImMaulGleich(text, this, anzahl);
	}
	
	final void erwarteAnzahlKoernerImMaulUngleich(int anzahl) {
	
		this.erwarteAnzahlKoernerImMaulUngleich(null, anzahl);
	}
	
	final void erwarteAnzahlKoernerImMaulUngleich(String text, int anzahl) {
	
		tdd.HamsterErwartungen.erwarteAnzahlKoernerImMaulUngleich(text, this, anzahl);
	}
	
	
	final void erwarteBlickrichtungNord() {
	
		this.erwarteBlickrichtungNord(null);
	}
	
	final void erwarteBlickrichtungNord(String text) {
	
		tdd.HamsterErwartungen.erwarteBlickrichtungNord(text, this);
	}
	
	final void erwarteBlickrichtungNichtNord() {
	
		this.erwarteBlickrichtungNichtNord(null);
	}
	
	final void erwarteBlickrichtungNichtNord(String text) {
	
		tdd.HamsterErwartungen.erwarteBlickrichtungNichtNord(text, this);
	}
	
	
	final void erwarteBlickrichtungWest() {
	
		this.erwarteBlickrichtungWest(null);
	}
	
	final void erwarteBlickrichtungWest(String text) {
	
		tdd.HamsterErwartungen.erwarteBlickrichtungWest(text, this);
	}
	
	final void erwarteBlickrichtungNichtWest() {
	
		this.erwarteBlickrichtungNichtWest(null);
	}
	
	final void erwarteBlickrichtungNichtWest(String text) {
	
		tdd.HamsterErwartungen.erwarteBlickrichtungNichtWest(text, this);
	}
	
	
	final void erwarteBlickrichtungSued() {
	
		this.erwarteBlickrichtungSued(null);
	}
	
	final void erwarteBlickrichtungSued(String text) {
	
		tdd.HamsterErwartungen.erwarteBlickrichtungSued(text, this);
	}
	
	final void erwarteBlickrichtungNichtSued() {
	
		this.erwarteBlickrichtungNichtSued(null);
	}
	
	final void erwarteBlickrichtungNichtSued(String text) {
	
		tdd.HamsterErwartungen.erwarteBlickrichtungNichtSued(text, this);
	}
	
	
	final void erwarteBlickrichtungOst() {
	
		this.erwarteBlickrichtungOst(null);
	}
	
	final void erwarteBlickrichtungOst(String text) {

		tdd.HamsterErwartungen.erwarteBlickrichtungOst(text, this);	
	}
	
	final void erwarteBlickrichtungNichtOst() {
	
		this.erwarteBlickrichtungNichtOst(null);
	}
	
	final void erwarteBlickrichtungNichtOst(String text) {
		
		tdd.HamsterErwartungen.erwarteBlickrichtungNichtOst(text, this);
	}
	
	
	final void erwarteVornFrei() {
		
		this.erwarteVornFrei(null);
	}
	
	final void erwarteVornFrei(String text) {
	
		tdd.HamsterErwartungen.erwarteVornFrei(text, this);
	}
	
	final void erwarteNichtVornFrei() {
	
		this.erwarteNichtVornFrei(null);
	}
	
	final void erwarteNichtVornFrei(String text) {
	
		tdd.HamsterErwartungen.erwarteNichtVornFrei(text, this);
	}
	
	
	final void erwarteKornDa() {
	
		this.erwarteKornDa(null);
	}
	
	final void erwarteKornDa(String text) {
	
		tdd.HamsterErwartungen.erwarteKornDa(text, this);
	}
	
	final void erwarteNichtKornDa() {
	
		this.erwarteNichtKornDa(null);
	}
	
	final void erwarteNichtKornDa(String text) {
	
		tdd.HamsterErwartungen.erwarteNichtKornDa(text, this);
	}
	

	final void erwarteMaulLeer() {
	
		this.erwarteMaulLeer(null);
	}
	
	final void erwarteMaulLeer(String text) {
	
		tdd.HamsterErwartungen.erwarteMaulLeer(text, this);
	}
	
	final void erwarteNichtMaulLeer() {
	
		this.erwarteNichtMaulLeer(null);
	}
	
	final void erwarteNichtMaulLeer(String text) {
	
		tdd.HamsterErwartungen.erwarteNichtMaulLeer(text, this);
	}
	
	
	final void erwarteAnzahlReihenGleich(int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlReihenGleich(territory, anzahl);
	}
	
	final void erwarteAnzahlReihenGleich(String text, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlReihenGleich(text, territory, anzahl);
	}
	
	final void erwarteAnzahlReihenUngleich(int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlReihenUngleich(territory, anzahl);
	}
	
	final void erwarteAnzahlReihenUngleich(String text, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlReihenUngleich(text, territory, anzahl);
	}
	
	
	final void erwarteAnzahlSpaltenGleich(int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlSpaltenGleich(territory, anzahl);
	}
	
	final void erwarteAnzahlSpaltenGleich(String text, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlSpaltenGleich(text, territory, anzahl);
	}
	
	final void erwarteAnzahlSpaltenUngleich(int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlSpaltenUngleich(territory, anzahl);
	}
	
	final void erwarteAnzahlSpaltenUngleich(String text, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlSpaltenUngleich(text, territory, anzahl);
	}
	
	
	final void erwarteGroeszeGleich(int reihen, int spalten) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteGroeszeGleich(territory, reihen, spalten);
	}
	
	final void erwarteGroeszeGleich(String text, int reihen, int spalten) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteGroeszeGleich(text, territory, reihen, spalten);
	}
	
	final void erwarteGroeszeUngleich(int reihen, int spalten) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteGroeszeUngleich(territory, reihen, spalten);
	}
	
	final void erwarteGroeszeUngleich(String text, int reihen, int spalten) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteGroeszeUngleich(text, territory, reihen, spalten);
	}
	
	
	final void erwarteAnzahlKoernerAufKachelGleich(int reihe, int spalte, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerAufKachelGleich(territory, reihe, spalte, anzahl);
	}
	
	final void erwarteAnzahlKoernerAufKachelGleich(String text, int reihe, int spalte, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerAufKachelGleich(text, territory, reihe, spalte, anzahl);
	}
	
	final void erwarteAnzahlKoernerAufKachelUngleich(int reihe, int spalte, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerAufKachelUngleich(territory, reihe, spalte, anzahl);
	}
	
	final void erwarteAnzahlKoernerAufKachelUngleich(String text, int reihe, int spalte, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerAufKachelUngleich(text, territory, reihe, spalte, anzahl);
	}
	
	
	final void erwarteKoernerAufKachel(int reihe, int spalte) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKoernerAufKachel(territory, reihe, spalte);
	}
	
	final void erwarteKoernerAufKachel(String text, int reihe, int spalte) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKoernerAufKachel(text, territory, reihe, spalte);
	}
	
	final void erwarteKeineKoernerAufKachel(int reihe, int spalte) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKeineKoernerAufKachel(territory, reihe, spalte);
	}
	
	final void erwarteKeineKoernerAufKachel(String text, int reihe, int spalte) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKeineKoernerAufKachel(text, territory, reihe, spalte);
	}
	
	
	final void erwarteAnzahlKoernerInReiheGleich(int reihe, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerInReiheGleich(territory, reihe, anzahl);
	}
	
	final void erwarteAnzahlKoernerInReiheGleich(String text, int reihe, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerInReiheGleich(text, territory, reihe, anzahl);
	}
	
	final void erwarteAnzahlKoernerInReiheUngleich(int reihe, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerInReiheUngleich(territory, reihe, anzahl);
	}
	
	final void erwarteAnzahlKoernerInReiheUngleich(String text, int reihe, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerInReiheUngleich(text, territory, reihe, anzahl);
	}
	
	
	final void erwarteKoernerInReihe(int reihe, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKoernerInReihe(territory, reihe);
	}
	
	final void erwarteKoernerInReihe(String text, int reihe, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKoernerInReihe(text, territory, reihe);
	}
	
	final void erwarteKeineKoernerInReihe(int reihe) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKeineKoernerInReihe(territory, reihe);
	}
	
	final void erwarteKeineKoernerInReihe(String text, int reihe) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKeineKoernerInReihe(text, territory, reihe);
	}
	
	
	final void erwarteAnzahlKoernerInSpalteGleich(int spalte, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerInSpalteGleich(territory, spalte, anzahl);
	}
	
	final void erwarteAnzahlKoernerInSpalteGleich(String text, int spalte, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerInSpalteGleich(text, territory, spalte, anzahl);
	}
	
	final void erwarteAnzahlKoernerInSpalteUngleich(int spalte, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerInSpalteUngleich(territory, spalte, anzahl);
	}
	
	final void erwarteAnzahlKoernerInSpalteUngleich(String text, int spalte, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerInSpalteUngleich(text, territory, spalte, anzahl);
	}
	
	
	final void erwarteKoernerInSpalte(int spalte) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKoernerInSpalte(territory, spalte);
	}
	
	final void erwarteKoernerInSpalte(String text, int spalte) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKoernerInSpalte(text, territory, spalte);
	}
	
	final void erwarteKeineKoernerInSpalte(int spalte) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKeineKoernerInSpalte(territory, spalte);
	}
	
	final void erwarteKeineKoernerInSpalte(String text, int spalte) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKeineKoernerInSpalte(text, territory, spalte);
	}
	
	
	final void erwarteAnzahlKoernerAufTerritoriumGleich(int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerAufTerritoriumGleich(territory, anzahl);
	}
	
	final void erwarteAnzahlKoernerAufTerritoriumGleich(String text, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerAufTerritoriumGleich(text, territory, anzahl);
	}
	
	final void erwarteAnzahlKoernerAufTerritoriumUngleich(int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerAufTerritoriumUngleich(territory, anzahl);
	}
	
	final void erwarteAnzahlKoernerAufTerritoriumUngleich(String text, int anzahl) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteAnzahlKoernerAufTerritoriumUngleich(text, territory, anzahl);
	}
	
	
	final void erwarteKoernerAufTerritorium() {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKoernerAufTerritorium(territory);
	}
	
	final void erwarteKoernerAufTerritorium(String text) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKoernerAufTerritorium(text, territory);
	}
	
	final void erwarteKeineKoernerAufTerritorium() {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKeineKoernerAufTerritorium(territory);
	}
	
	final void erwarteKeineKoernerAufTerritorium(String text) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKeineKoernerAufTerritorium(text, territory);
	}
	
	
	final void erwarteMauerAufKachel(int reihe, int spalte) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteMauerAufKachel(territory, reihe, spalte);
	}
	
	final void erwarteMauerAufKachel(String text, int reihe, int spalte) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteMauerAufKachel(text, territory, reihe, spalte);
	}
	
	final void erwarteKeineMauerAufKachel(int reihe, int spalte) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKeineMauerAufKachel(territory, reihe, spalte);
	}
	
	final void erwarteKeineMauerAufKachel(String text, int reihe, int spalte) {
	
		ITerritory territory = this.territoryStateController.getStateManager().getTerritoryState();
		
		tdd.HamsterErwartungen.erwarteKeineMauerAufKachel(text, territory, reihe, spalte);
	}
}
