package tdd.models;



import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import util.Observable;



public class Testsuite extends Observable {
	
	
	
	private Testsuite testsuite;
	private File directory;
	private List<Testsuite> testsuites = new ArrayList<Testsuite>();
	private List<Test> tests = new ArrayList<Test>();
	
	
	
	public Testsuite(Testsuite testsuite, File directory) {

		if(directory == null) throw new IllegalArgumentException("directory is NULL");
		if(!directory.isDirectory()) throw new IllegalArgumentException("directory is not a directory");
		
		this.testsuite = testsuite;
		this.directory = directory;
		
		if(this.testsuite != null) {
			
			this.testsuite.add(this);
		}
	}
	
	
	
	public Testsuite getTestsuite() {
		
		return this.testsuite;
	}
	
	public File getDirectory() {
		
		return this.directory;
	}
	
	public String getName() {
		
		return this.getDirectory().getName();
	}
	
	public String getFullName() {
		
		return this.getFullName(".");
	}
	
	public String getFullName(String delimeter) {
		
		Testsuite parent = this.getTestsuite();
		
		if(parent == null) {
			
			return this.getName();
			
		} else {
			
			return parent.getFullName() + delimeter + this.getName();
		}
	}
	
	
	
	public Testsuite[] getTestsuites() {
		
		return this.testsuites.toArray(new Testsuite[this.testsuites.size()]);
	}
	
	public Testsuite[] getPath() {
		
		if(this.getTestsuite() != null) {
			
			List<Testsuite> path = Arrays.asList(this.getTestsuite().getPath());
			path.add(this.getTestsuite());
			
			return path.toArray(new Testsuite[path.size()]);
		}

		return new Testsuite[] {};
	}
	
	public Testsuite getTestsuite(int index) {
		
		return this.testsuites.get(index);
	}
	
	public boolean existsTestsuite(String name) {
		
		for(Testsuite testsuite : this.testsuites) {
			
			if(Objects.equals(testsuite.getName(), name)) return true;
		}
		
		return false;
	}
	
	public int getIndexOfTestsuite(Testsuite testsuite) {
		
		return this.testsuites.indexOf(testsuite);
	}
	
	public int getNumberOfTestsuites() {
		
		return this.testsuites.size();
	}
	
	public boolean contains(Object value) {
		
		return this.testsuites.contains(value) || this.tests.contains(value);
	}
	
	public void add(Testsuite testsuite) {
		
		this.testsuites.add(testsuite);
		this.notifyObservers();
	}
	
	public void remove(Testsuite testsuite) {
		
		this.testsuites.remove(testsuite);
		this.notifyObservers();
	}
	
	public void removeAllTestsuites() {
		
		this.testsuites.clear();
	}
	
	public Test[] getTests() {
		
		return this.tests.toArray(new Test[this.tests.size()]);
	}
	
	public Test[] getAllTests() {
		
		List<Test> tests = new ArrayList<Test>();
		
		for(Testsuite testsuite : this.testsuites) {
			
			tests.addAll(Arrays.asList(testsuite.getAllTests()));
		}
		
		tests.addAll(this.tests);
		
		return tests.toArray(new Test[tests.size()]);
	}
	
	public Test getTest(int index) {
		
		return this.tests.get(index);
	}
	
	public boolean existsTest(String name) {
		
		for(Test test : this.tests) {
			
			if(Objects.equals(test.getName(), name)) return true;
		}
		
		return false;
	}
	
	public int getIndexOfTest(Test test) {
		
		return this.tests.indexOf(test);
	}
	
	public int getNumberOfTests() {
		
		return this.tests.size();
	}
	
	public void add(Test test) {
		
		this.tests.add(test);
		this.notifyObservers();
	}
	
	public void remove(Test test) {
		
		this.tests.remove(test);
		this.notifyObservers();
	}
	
	public void removeAllTests() {
		
		this.tests.clear();
	}
	
	public void removeAll() {
		
		this.removeAllTests();
		this.removeAllTestsuites();
	}
	
	
	
	@Override
	public String toString() {
		
		return this.getDirectory().getName();
	}
	
	@Override
	public int hashCode() {
		
		return Objects.hashCode(this.getDirectory());
	}
	
	@Override
	public boolean equals(Object obj) {
		
		if(!(obj instanceof Testsuite)) return false;
		
		Testsuite t = (Testsuite) obj;
		
		if(!Objects.equals(this.getDirectory(), t.getDirectory())) {
			
			return false;
		}
		
		return true;
	}
}
