package tdd.models;



import java.util.ArrayList;
import java.util.List;

import util.Observable;
import util.Observer;



public class TestRunnerInformation extends Observable {

	
	
	private List<TestCaseRunInformation> testCaseRunInformations = new ArrayList<TestCaseRunInformation>();
	
	
	
	public TestRunnerInformation() {}
	
	
	
	public void clear() {
		
		this.testCaseRunInformations.clear();
		this.notifyObservers();
	}
	
	public int getCountOfTestCaseRunInformations() {
		
		return this.testCaseRunInformations.size();
	}
	
	public TestCaseRunInformation get(int index) {
		
		return this.testCaseRunInformations.get(index);
	}
	
	public TestCaseRunInformation[] getTestCaseRunInformations() {
		
		return this.testCaseRunInformations.toArray(new TestCaseRunInformation[this.testCaseRunInformations.size()]);
	}
	
	public TestCaseRunInformation add(String test, String testCase, boolean running) {
		
		TestCaseRunInformation testCaseRunInformation = new TestCaseRunInformation(test, testCase, running);
		testCaseRunInformation.addObserver(this.testCaseRunInformationObserver);
		
		this.testCaseRunInformations.add(testCaseRunInformation);
		this.notifyObservers();
		
		return testCaseRunInformation;
	}
	
	public boolean hasAnyError() {
		
		for(TestCaseRunInformation testCaseRunInformation : this.testCaseRunInformations) {
			
			if(testCaseRunInformation.getError() != null) return true;
		}
		
		return false;
	}
	
	
	
	private final Observer testCaseRunInformationObserver = new Observer() {
		
		@Override
		public void update() {
			
			notifyObservers();
		}
	};
}
