package tdd.models;



import java.util.Objects;

import tdd.errors.ErwartungError;
import util.Observable;



public class TestCaseRunInformation extends Observable {

	
	
	private String test;
	private String testCase;
	private boolean running = false;
	private ErwartungError error;

	
	
	public TestCaseRunInformation(String test, String testCase, boolean running) {
		
		this.test = test;
		this.testCase = testCase;
		this.running = running;
	}
	
	
	
	public String getTest() {
		
		return this.test;
	}
	
	public String getTestCase() {
		
		return this.testCase;
	}
	
	public synchronized boolean isRunning() {
		
		return this.running;
	}
	
	public synchronized void setRunning(boolean running) {
		
		if(this.running != running) {
			
			this.running = running;
			this.notifyObservers();
		}
	}
	
	public synchronized ErwartungError getError() {
		
		return this.error;
	}
	
	public synchronized void setError(ErwartungError error) {
		
		if(!Objects.equals(this.getError(), error)) {
			
			this.error = error;
			
			this.deactivateNotification();
			this.setRunning(false);
			this.activateNotification();
			
			this.notifyObservers();
		}
	}

	
	
	@Override
	public int hashCode() {
	
		return Objects.hash(this.getTest(), this.getTestCase(), this.isRunning(), this.getError());
	}
	
	@Override
	public boolean equals(Object obj) {
		
		if(!(obj instanceof TestCaseRunInformation)) return false;
		
		TestCaseRunInformation t = (TestCaseRunInformation) obj;
		
		if(!Objects.equals(this.getTest(), t.getTest())) return false;
		if(!Objects.equals(this.getTestCase(), t.getTestCase())) return false;
		if(!Objects.equals(this.isRunning(), t.isRunning())) return false;
		if(!Objects.equals(this.getError(), t.getError())) return false;
		
		return true;
	}
}
