package tdd.models;



import java.io.IOException;
import java.util.Objects;



public class Test {
	
	
	
	private Testsuite testsuite;
	private String name;
	private TestContent content;
	
	
	
	public Test(Testsuite testsuite, String name, TestContent content) {
		
		if(name == null) throw new IllegalArgumentException("name is NULL");
		if(name.length() == 0) throw new IllegalArgumentException("name length is 0");
	
		this.testsuite = testsuite;
		this.name = name;
		this.content = content;
		this.content.setTest(this);
		this.testsuite.add(this);
	}
	
	
	
	public Testsuite getTestsuite() {
		
		return this.testsuite;
	}
	
	public String getName() {
		
		return this.name;
	}
	
	public String getFullName() {
		
		return this.getFullName(".");
	}
	
	public String getFullName(String delimeter) {
		
		return this.getTestsuite().getFullName(delimeter) + delimeter + this.getName();
	}
	
	public TestContent getTestContent() {
		
		return this.content;
	}
	
	public String generateCode() throws IOException {
		
		return this.getTestContent().generateCode(this.getName());
	}

	
	
	@Override
	public String toString() {
	
		return this.getName();
	}
	
	@Override
	public int hashCode() {
		
		return Objects.hashCode(this.getName());
	}
	
	@Override
	public boolean equals(Object obj) {
		
		if(!(obj instanceof Test)) return false;
		
		Test t = (Test) obj;
		
		if(!Objects.equals(this.getName(), t.getName())) return false;
		
		return true;
	}
}
