package tdd.models;



import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import util.Observable;



public class TerritoryStates extends Observable implements Serializable {

	
	
	private static final long serialVersionUID = -6590669756568081446L;
	
	
	
	private File directory;
	private List<TerritoryState> territoryStates = new ArrayList<TerritoryState>();
	
	
	
	public TerritoryStates() {}
	
	
	
	public void set(File directory, TerritoryState[] territoryStates) {
		
		if(!Objects.equals(this.getDirectory(), directory) || !Objects.equals(this.getTerritoryStates(), territoryStates)) {
			
			this.directory = directory;
			
			this.territoryStates.clear();
			this.territoryStates.addAll(Arrays.asList(territoryStates));
			
			this.notifyObservers();
		}
	}
	
	public File getDirectory() {
		
		return this.directory;
	}
	
	public TerritoryState[] getTerritoryStates() {
		
		return this.territoryStates.toArray(new TerritoryState[this.territoryStates.size()]);
	}
	
	public int getNumberOfTerritoryStates() {
		
		return this.territoryStates.size();
	}
	
	public TerritoryState getTerritoryState(int index) {
		
		return this.territoryStates.get(index);
	}
	
	public TerritoryState getTerritoryState(String name) {
		
		for(TerritoryState territoryState : this.territoryStates) {
			
			if(Objects.equals(territoryState.getName(), name)) return territoryState;
		}
		
		return null;
	}
	
	public boolean exists(String name) {
		
		TerritoryState state = this.getTerritoryState(name);
		
		return state != null;
	}
	
	public void add(TerritoryState territoryState) {
		
		TerritoryState state = this.getTerritoryState(territoryState.getName());
		
		if(state != null) {
			
			this.remove(state);
		}
		
		this.territoryStates.add(territoryState);
		this.notifyObservers();
	}
	
	public void moveUp(TerritoryState territoryState) {
		
		int index = this.territoryStates.indexOf(territoryState);
		
		if(index != -1 && index > 0) {
			
			int newIndex = index - 1;
			
			TerritoryState temp = this.territoryStates.get(newIndex);
			this.territoryStates.remove(newIndex);
			this.territoryStates.add(index, temp);
			
			this.notifyObservers();
		}
	}
	
	public void moveDown(TerritoryState territoryState) {
		
		int index = this.territoryStates.indexOf(territoryState);
		
		if(index != -1 && index < this.territoryStates.size() - 1) {
			
			int newIndex = index + 1;
			
			TerritoryState temp = this.territoryStates.get(newIndex);
			this.territoryStates.remove(newIndex);
			this.territoryStates.add(index, temp);
			
			this.notifyObservers();
		}
	}
	
	public void remove(TerritoryState territoryState) {
		
		this.territoryStates.remove(territoryState);
		this.notifyObservers();
	}
}
