package tdd.models;



import java.io.Serializable;

import tdd.interfaces.IHamster;
import tdd.interfaces.ITerritory;



public class TerritoryState implements ITerritory, Serializable {



	private static final long serialVersionUID = 1536769923935443775L;
	
	
	
	private String name;
	private int numberOfRows;
	private int numberOfColumns;
	private int[][] numberOfGrains;
	private boolean[][] wall;
	private HamsterState hamsterState;
	private boolean temp;
	
	
	
	public TerritoryState(String name) {
		
		this.name = name;
	}
	
	public TerritoryState(String name, ITerritory territory) {
		
		this(territory);
		
		this.name = name;
	}
	
	public TerritoryState(ITerritory territory) {
	
		this.numberOfRows = territory.getNumberOfRows();
		this.numberOfColumns = territory.getNumberOfColumns();
		
		this.numberOfGrains = new int[this.numberOfRows][this.numberOfColumns];
		this.wall = new boolean[this.numberOfRows][this.numberOfColumns];
		
		for(int i=0; i<this.numberOfRows; i++) {
			
			for(int j=0; j<this.numberOfColumns; j++) {
				
				this.numberOfGrains[i][j] = territory.getNumberOfGrainsOnTile(i, j);
				this.wall[i][j] = territory.isWallOnTile(i, j);
			}
		}
		
		if(territory.getHamsterState() != null) {
			
			this.hamsterState = new HamsterState(territory.getHamsterState());
		}
	}
	
	public TerritoryState(ITerritory territory, HamsterState hamsterState) {
		
		this(territory);
		
		this.hamsterState = hamsterState;
	}

	
	
	public boolean isTemp() {
		
		return this.temp;
	}
	
	public void setTemp(boolean temp) {
		
		this.temp = temp;
	}
	
	public String getName() {
		
		return this.name;
	}

	@Override
	public int getNumberOfRows() {
		
		return this.numberOfRows;
	}

	@Override
	public int getNumberOfColumns() {
		
		return this.numberOfColumns;
	}

	@Override
	public int getNumberOfGrainsOnTile(int row, int column) {
		
		return this.numberOfGrains[row][column];
	}

	@Override
	public boolean isWallOnTile(int row, int column) {
		
		return this.wall[row][column];
	}

	@Override
	public IHamster getHamsterState() {
		
		return this.hamsterState;
	}
	
	@Override
	public String toString() {
		
		return this.getName();
	}
}
