package tdd.models;



import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

import tdd.templates.Templates;
import tdd.utils.Streams;
import util.Observer;



public class TerritoryCheckpointTestContent extends TestContent implements Serializable {


	
	private static final long serialVersionUID = 767758606637776135L;
	
	
	
	private String methodCall;
	private String startTerritory;
	private TerritoryStates territoryStates = new TerritoryStates();
	private TerritoryStates blacklist = new TerritoryStates();
	
	
	
	public TerritoryCheckpointTestContent() {
	
		this.territoryStates.addObserver(new Observer() {
			
			@Override
			public void update() {
				
				notifyObservers();
			}
		});
		
		this.blacklist.addObserver(new Observer() {
			
			@Override
			public void update() {
				
				notifyObservers();
			}
		});
	}
	
	
	
	public String getStartTerritory() {
		
		return this.startTerritory;
	}
	
	public void setStartTerritory(String startTerritory) {
		
		if(!Objects.equals(this.getStartTerritory(), startTerritory)) {
			
			this.startTerritory = startTerritory;
			
			this.notifyObservers();
		}
	}
	
	public void setMethodCall(String methodCall) {
		
		if(!Objects.equals(this.getMethodCall(), methodCall)) {
			
			this.methodCall = methodCall;
			
			this.notifyObservers();
		}
	}
	
	public String getMethodCall() {
		
		return this.methodCall;
	}

	public TerritoryStates getTerritoryStates() {
		
		return this.territoryStates;
	}
	
	public TerritoryStates getBlacklist() {
		
		return this.blacklist;
	}
	
	
	
	@Override
	public String generateCode(String testName) throws IOException {
	
		String startTerritory = this.getStartTerritory();
		
		if(startTerritory != null) startTerritory = startTerritory.replace("\\", "\\\\");
		
		Template template = Templates.create(Streams.fromResources(Templates.TerritoryCheckpointTestClass.PATH));
		template.set(Templates.TerritoryCheckpointTestClass.VARIABLE_TEST_NAME, testName);
		template.set(Templates.TerritoryCheckpointTestClass.VARIABLE_METHOD_CALL, this.getMethodCall());
		template.set(Templates.TerritoryCheckpointTestClass.VARIABLE_START_STATE_FILE, startTerritory);
		
		StringBuilder initializeTerritories = new StringBuilder();
		TerritoryState[] territorsStates = this.territoryStates.getTerritoryStates();
		
		for(int i=0; i<territorsStates.length; i++) {
			
			Template initializeTerritory = Templates.create(Streams.fromResources(Templates.InitializeTerritory.PATH));
			initializeTerritory.set(Templates.InitializeTerritory.VARIABLE_INDEX, i);
			initializeTerritory.set(Templates.InitializeTerritory.VARIABLE_TERRITORY_NAME, territorsStates[i].getName());
			
			initializeTerritories.append(initializeTerritory.compile());
		}
		
		template.set(Templates.TerritoryCheckpointTestClass.VARIABLE_TERRITORIES_LENGTH, territorsStates.length);
		template.set(Templates.TerritoryCheckpointTestClass.VARIABLE_INITIALIZE_TERRITORIES, initializeTerritories.toString());
		
		StringBuilder initializeBlacklist = new StringBuilder();
		TerritoryState[] blacklist = this.blacklist.getTerritoryStates();
		
		for(int i=0; i<blacklist.length; i++) {
			
			Template initializeBlacklistEntry = Templates.create(Streams.fromResources(Templates.InitializeBlacklist.PATH));
			initializeBlacklistEntry.set(Templates.InitializeBlacklist.VARIABLE_INDEX, i);
			initializeBlacklistEntry.set(Templates.InitializeBlacklist.VARIABLE_TERRITORY_NAME, blacklist[i].getName());
			
			initializeBlacklist.append(initializeBlacklistEntry.compile());
		}
		
		template.set(Templates.TerritoryCheckpointTestClass.VARIABLE_BLACKLIST_LENGTH , blacklist.length);
		template.set(Templates.TerritoryCheckpointTestClass.VARIABLE_INITIALIZE_BLACKLIST, initializeBlacklist.toString());
		
		return template.compile();
	}
	
	private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
		
		in.defaultReadObject();
		
		territoryStates.addObserver(new Observer() {
			
			@Override
			public void update() {
				
				notifyObservers();
			}
		});
		
		blacklist.addObserver(new Observer() {
			
			@Override
			public void update() {
				
				notifyObservers();
			}
		});
	}
}
