package tdd.models;



import java.util.HashMap;
import java.util.Map;



public class Template {
	
	
	
	public static final String VARIABLE_PREFIX = "<";
	public static final String VARIABLE_SUFFIX = ">";

	
	
	private String template;
	private Map<String, Object> variables = new HashMap<String, Object>();
	
	
	
	public Template(String template) {
		
		this.template = template;
	}
	
	
	
	public String getTemplate() {
		
		return this.template;
	}
	
	public void set(String key, Object value) {
		
		this.variables.put(key, value);
	}
	
	public void clear(String key) {
		
		this.variables.remove(key);
	}
	
	public void clear() {
		
		this.variables.clear();
	}
	
	public String compile() {
		
		String result = this.getTemplate();
		
		for(Map.Entry<String, Object> variable : this.variables.entrySet()) {
			
			String value = null;
			
			if(variable.getValue() == null) {
				
				value = "";
				
			} else {
				
				value = variable.getValue().toString();
			}
			
			result = result.replace(VARIABLE_PREFIX + variable.getKey() + VARIABLE_SUFFIX, value);
		}
		
		return result;
	}
}
