package tdd.models;



import java.io.Serializable;

import model.Territorium;
import tdd.interfaces.IHamster;



public class HamsterState implements IHamster, Serializable {

	

	private static final long serialVersionUID = -4438783135271247448L;
	
	
	
	private int row;
	private int column;
	private int numberOfGrains;
	private boolean directionNorth;
	private boolean directionWest;
	private boolean directionSouth;
	private boolean directionEast;
	private boolean aheadFree = false;
	private boolean mouthEmpty = false;
	private boolean grainThere = false;
	
	
	
	public HamsterState(IHamster hamster) {
	
		this.row = hamster.getRow();
		this.column = hamster.getColumn();
		this.numberOfGrains = hamster.getNumberOfGrains();
		this.directionNorth = hamster.isDirectionNorth();
		this.directionWest = hamster.isDirectionWest();
		this.directionSouth = hamster.isDirectionSouth();
		this.directionEast = hamster.isDirectionEast();
		this.aheadFree = hamster.isAheadFree();
		this.mouthEmpty = hamster.isMouthEmpty();
		this.grainThere = hamster.isGrainThere();
	}
	
	public HamsterState(int row, int column, int numberOfGrains, int direction) {
		
		this.row = row;
		this.column = column;
		this.numberOfGrains = numberOfGrains;
		
		this.directionNorth = Territorium.NORD == direction;
		this.directionEast = Territorium.OST == direction;
		this.directionSouth = Territorium.SUED == direction;
		this.directionWest = Territorium.WEST == direction;
	}
	
	
	
	@Override
	public int getRow() {
	
		return this.row;
	}

	@Override
	public int getColumn() {
	
		return this.column;
	}

	@Override
	public int getNumberOfGrains() {
	
		return this.numberOfGrains;
	}

	@Override
	public boolean isDirectionNorth() {
	
		return this.directionNorth;
	}

	@Override
	public boolean isDirectionWest() {
	
		return this.directionWest;
	}

	@Override
	public boolean isDirectionSouth() {
	
		return this.directionSouth;
	}

	@Override
	public boolean isDirectionEast() {

		return this.directionEast;
	}

	@Override
	public boolean isAheadFree() {
	
		return aheadFree;
	}

	@Override
	public boolean isMouthEmpty() {
		
		return mouthEmpty;
	}

	@Override
	public boolean isGrainThere() {
		
		return grainThere;
	}
}
