package tdd.models;



import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

import tdd.templates.Templates;
import tdd.utils.Streams;



public class FinalStateTestContent extends TestContent implements Serializable {

	
	
	private static final long serialVersionUID = 6429461223137452377L;

	
	
	private String startStateFilename;
	private String methodCall;
	private String endStateFilename;
	
	
	
	public void setStartStateFilename(String startStateFilename) {
		
		if(!Objects.equals(this.getStartStateFilename(), startStateFilename)) {
			
			this.startStateFilename = startStateFilename;
			
			this.notifyObservers();
		}
	}
	
	public String getStartStateFilename() {
		
		return this.startStateFilename;
	}
	
	public void setMethodCall(String methodCall) {
		
		if(!Objects.equals(this.getMethodCall(), methodCall)) {
			
			this.methodCall = methodCall;
			
			this.notifyObservers();
		}
	}
	
	public String getMethodCall() {
		
		return this.methodCall;
	}
	
	public void setEndStateFilename(String endStateFilename) {
		
		if(!Objects.equals(this.getEndStateFilename(), endStateFilename)) {
			
			this.endStateFilename = endStateFilename;
			
			this.notifyObservers();
		}
	}
	
	public String getEndStateFilename() {
		
		return this.endStateFilename;
	}
	
	
	
	@Override
	public String generateCode(String testName) throws IOException {
	
		String startStateFilename = this.getStartStateFilename();
		String endStateFilename = this.getEndStateFilename();
		
		if(startStateFilename != null) startStateFilename = startStateFilename.replace("\\", "\\\\");
		if(endStateFilename != null) endStateFilename = endStateFilename.replace("\\", "\\\\");
		
		Template template = Templates.create(Streams.fromResources(Templates.FinalStateTestClass.PATH));
		template.set(Templates.FinalStateTestClass.VARIABLE_TEST_NAME, testName);
		template.set(Templates.FinalStateTestClass.VARIABLE_START_STATE_FILE, startStateFilename);
		template.set(Templates.FinalStateTestClass.VARIABLE_METHOD_CALL, this.getMethodCall());
		template.set(Templates.FinalStateTestClass.VARIABLE_END_STATE_FILE, endStateFilename);
		
		return template.compile();
	}
}
