package tdd.models;



import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

import tdd.templates.Templates;
import tdd.utils.Streams;



public class CustomTestContent extends TestContent implements Serializable {


	
	private static final long serialVersionUID = -6228149262317407550L;
	
	public static final String DEFAULT_USER_CODE = 
			"@Einrichtung\n" +
			"void richteEin() {\n" +
			"\t\n" +
			"}\n" +
			"\n" +
			"@Test\n" +
			"void teste() {\n" +
			"\t\n" +
			"}\n";
	
	
	
	private String userCode;
	
	
	
	public CustomTestContent() {
	
		this.userCode = DEFAULT_USER_CODE;
	}
	
	
	
	public String getUserCode() {
		
		return this.userCode;
	}
	
	public void setUserCode(String userCode) {
		
		if(!Objects.equals(this.getUserCode(), userCode)) {
			
			this.userCode = userCode;
			
			this.notifyObservers();
		}
	}
	
	
	
	@Override
	public String generateCode(String testName) throws IOException {

		Template template = Templates.create(Streams.fromResources(Templates.CustomTestClass.PATH));
		template.set(Templates.CustomTestClass.VARIABLE_TEST_NAME, testName);
		template.set(Templates.CustomTestClass.VARIABLE_CONTENT, this.getUserCode());
		
		return template.compile();
	}
}
