package tdd.errors;



import java.util.Arrays;



public class GleichErwartungError extends ErwartungError {

	
	
	private static final long serialVersionUID = 8042366472377592103L;
	
	
	
	public static final String FORMAT = "Erwartet wurde der Wert: %s, Ist-Wert: %s";
	
	
	
	private GleichErwartungError(String erwartet, String ist, String text) {

		super(String.format(FORMAT, erwartet, ist), text);
	}
	
	public GleichErwartungError(boolean erwartet, boolean ist, String text) {
		
		this(String.valueOf(erwartet), String.valueOf(ist), text);
	}
	
	public GleichErwartungError(boolean[] erwartet, boolean[] ist, String text) {
		
		this(Arrays.toString(erwartet), Arrays.toString(ist), text);
	}
	
	public GleichErwartungError(char[] erwartet, char[] ist, String text) {
		
		this(Arrays.toString(erwartet), Arrays.toString(ist), text);
	}
	
	public GleichErwartungError(byte[] erwartet, byte[] ist, String text) {
		
		this(Arrays.toString(erwartet), Arrays.toString(ist), text);
	}
	
	public GleichErwartungError(short[] erwartet, short[] ist, String text) {
		
		this(Arrays.toString(erwartet), Arrays.toString(ist), text);
	}
	
	public GleichErwartungError(int[] erwartet, int[] ist, String text) {
		
		this(Arrays.toString(erwartet), Arrays.toString(ist), text);
	}
	
	public GleichErwartungError(long erwartet, long ist, String text) {
		
		this(String.valueOf(erwartet), String.valueOf(ist), text);
	}

	public GleichErwartungError(long[] erwartet, long[] ist, String text) {
		
		this(Arrays.toString(erwartet), Arrays.toString(ist), text);
	}
}
