package tdd.errors;



public class ErwartungError extends Error {

	
	
	private static final long serialVersionUID = 6199921851794440801L;
	
	
	
	public ErwartungError(String information, String text) {
		
		super(Message(information, text));
	}
	
	
	
	private static final String Message(String information, String text) {
		
		StringBuilder builder = new StringBuilder();
		builder.append(information);
		
		if(text != null) {
			
			builder.append("\n\n");
			builder.append(" (");
			builder.append(text);
			builder.append(")");
		}
		
		return builder.toString();
	}
	
	@Override
	public String toString() {
		
		return this.getMessage();
	}
	
	@Override
	public String getMessage() {
		
		return super.getMessage();
	}
}
