package tdd.controllers;



import java.io.File;
import java.io.IOException;

import javax.tools.JavaFileObject;

import tdd.interfaces.ICompilerManager;
import tdd.interfaces.IProgramManager;
import tdd.models.Template;
import tdd.models.TestClassesDirectory;
import tdd.templates.Templates;
import tdd.utils.Streams;



public class TestClassesController {

	
	
	private TestClassesDirectory testClassesDirectory;
	private IProgramManager programManager;
	private ICompilerManager compilerManager;
	
	
	
	public TestClassesController(TestClassesDirectory testClassesDirectory, IProgramManager programManager, ICompilerManager compilerManager) {
		
		this.testClassesDirectory = testClassesDirectory;
		this.programManager = programManager;
		this.compilerManager = compilerManager;
	}
	
	
	
	public TestClassesDirectory getTestClassesDirectory() {
		
		return this.testClassesDirectory;
	}
	
	public IProgramManager getProgramManager() {
		
		return this.programManager;
	}
	
	public ICompilerManager getCompilerManager() {
		
		return this.compilerManager;
	}
	
	
	
	public void setTestClassesDirectory(File directory) {
		
		if(!directory.exists()) {
			
			if(!directory.mkdirs()) {
				
				//TODO throw exception
			}
			
		} else {
			
			if(!directory.isDirectory()) {
				
				//TODO throw exception
			}
		}
		
		this.getTestClassesDirectory().setDirectory(directory);
	}
	
	public boolean compileTestClasses(String programClassName) {
		
		try {
			
			Template template = Templates.create(Streams.fromResources(Templates.BaseTest.PATH));
			template.set(Templates.BaseTest.VARIABLE_PROGRAM_NAME, programClassName);
			
			String source = template.compile();
			File directory = this.getTestClassesDirectory().getDirecory();
			String className = "BaseTest";
			
			JavaFileObject javaFileObject = this.getCompilerManager().createJavaFileObject(source, className, directory);
			
			return this.getCompilerManager().compile(javaFileObject, new File[] {this.getProgramManager().getProgramDirectory()}, null);
			
		} catch (IOException e) {
		
			//TODO throw Exception ... 
		}
		
		return false;
	}
}
