package tdd.controllers;



import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import tdd.errors.TerritoriumNichtGefundenFehler;
import tdd.interfaces.IStateManager;
import tdd.interfaces.ITerritory;
import tdd.models.TerritoryState;
import tdd.models.TerritoryStateContainer;
import tdd.models.TerritoryStates;
import tdd.models.TerritoryStatesDirectory;
import tdd.utils.Files;



public class TerritoryStateController {
	
	
	
	//public static final String TERRITORY_STATE_FILE_SUFFIX = ".state";

	
	
	private IStateManager stateManager;
	private TerritoryStateContainer territoryStateContainer;
	private TerritoryStates territoryStates;
	private TerritoryStatesDirectory territoryStatesDirectory;
	
	
	
	public TerritoryStateController(
			IStateManager stateManager, 
			TerritoryStateContainer territoryStateContainer, 
			TerritoryStates territoryStatesContainer,
			TerritoryStatesDirectory territoryStatesDirectory) {
	
		this.stateManager = stateManager;
		this.territoryStateContainer = territoryStateContainer;
		this.territoryStates = territoryStatesContainer;
		this.territoryStatesDirectory = territoryStatesDirectory;
	}
	
	
	
	public IStateManager getStateManager() {
		
		return this.stateManager;
	}
	
	public TerritoryStateContainer getTerritoryStateContainer() {
		
		return this.territoryStateContainer;
	}
	
	public TerritoryStates getTerritoryStates() {
		
		return this.territoryStates;
	}
	
	public TerritoryStatesDirectory getTerritoryStatesDirectory() {
		
		return this.territoryStatesDirectory;
	}
	
	
	
	public void setTerritoryStateDirectory(File directory) {
		
		if(!directory.exists()) {
			
			if(!directory.mkdirs()) {
				
				//TODO throw exception
			}
			
		} else {
			
			if(!directory.isDirectory()) {
				
				//TODO throw exception
			}
		}
		
		this.getTerritoryStatesDirectory().setDirectory(directory);
		
		List<TerritoryState> territoryStates = new ArrayList<TerritoryState>();
		File[] files = directory.listFiles();
		
		for(File file : files) {
			
			TerritoryState territoryState = this.deserializeTerritory(file);
			
			if(territoryState != null) {
				
				territoryStates.add(territoryState);
			}
		}
		
		this.getTerritoryStates().set(directory, territoryStates.toArray(new TerritoryState[territoryStates.size()]));
	}
	
	public void setCurrentTerritoryState(ITerritory territory) {
		
		this.getStateManager().setTerritoryState(territory);
	}

	public void setCurrentTerritoryState(String name) {
		
		this.setCurrentTerritoryState(this.getTerritoryState(name));
	}

	public void loadTerritoryState(String name) {
		
		this.getTerritoryStateContainer().setTerritoryState(this.getTerritoryStates().getTerritoryState(name));
	}
	
	public void createTerritoryState(String name) {
		
		TerritoryState territoryState = new TerritoryState(name);
		
		this.serializeTerritoryState(territoryState);
		this.getTerritoryStates().add(territoryState);
	}
	
	public TerritoryState getTerritoryState(String name) {
		
		for(TerritoryState territoryState : this.territoryStates.getTerritoryStates()) {
			
			if(Objects.equals(territoryState.getName(), name)) {

				return territoryState;
			}
		}
		
		throw new TerritoriumNichtGefundenFehler(name);
	}
	
	public void deleteTerritoryState(TerritoryState state) {
		
		File file = new File(this.getTerritoryStates().getDirectory(), state.getName());
		
		Files.delete(file);
		this.getTerritoryStates().remove(state);
	}
	
	public void saveTerritoryState(TerritoryState state) {
		
		this.serializeTerritoryState(state);
		this.getTerritoryStates().add(state);
	}
	
	public String saveTempTerritoryState(String prefix, TerritoryStates states) {

		String name = prefix;
		int counter = 1;
		
		while(this.getTerritoryStates().exists(name + " " + counter)) {
			
			counter++;
		}
		
		name += " " + counter;
		
		TerritoryState state = new TerritoryState(name, this.getStateManager().getTerritoryState());
		state.setTemp(true);
		
		this.saveTerritoryState(state);
		
		if(states != null) states.add(state);
		
		return name;
	}
	
	
	
	public TerritoryState deserializeTerritory(File file) {
		
		FileInputStream fs = null;
		ObjectInputStream is = null;
		
		try {
			
			fs = new FileInputStream(file.getAbsolutePath());
			is = new ObjectInputStream(fs);
			/*Territorium ter = (Territorium) is.readObject();
			int row = is.readInt();
			int col = is.readInt();
			int dir = is.readInt();
			int grains = is.readInt();
			is.close();
			
			HamsterState hamsterState = new HamsterState(row, col, grains, dir);
			TerritoryState territoryState = new TerritoryState(ter, hamsterState);
			 */
		
			return (TerritoryState) is.readObject();
			
		} catch (ClassNotFoundException e) {
			
			System.err.println(e.toString());
			
		} catch (IOException e) {
			
			System.err.println(e.toString());
		
		} catch (Throwable e) {
			
			System.err.println(e.toString());
			
		} finally {
			if (is != null) {
				try {
					is.close();
				} catch (IOException e) {
				}
			}
			if (fs != null) {
				try {
					fs.close();
				} catch (IOException e) {
				}
			}
		}
		
		return null;
	}
	
	private void serializeTerritoryState(TerritoryState territoryState) {
		
		FileOutputStream fos = null;
		ObjectOutputStream oos = null;
		
		try {
			
			File file = new File(this.getTerritoryStates().getDirectory(), territoryState.getName());
			fos = new FileOutputStream(file);
			oos = new ObjectOutputStream(fos);
			
			oos.writeObject(territoryState);
			
		} catch (Exception e) {
			
			//TODO throw exception
			return;
			
		} finally {
			
			if(oos != null) {
				
				try {
					
					oos.close();
					
				} catch (IOException e) {}
			}
			
			if(fos != null) {
				
				try {
					
					fos.close();
					
				} catch (IOException e) {}
			}
		}
	}
}
