package tdd.adapters;



import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import tdd.controllers.TestsuiteController;
import tdd.models.Testsuite;



public class CreateTestsuiteActionAdapter implements ActionListener {

	
	
	private TestsuiteController testsuiteController;
	private Testsuite testsuite;
	
	
	
	public CreateTestsuiteActionAdapter(TestsuiteController testsuiteController, Testsuite testsuite) {
	
		this.testsuiteController = testsuiteController;
		this.testsuite = testsuite;
	}
	
	
	
	@Override
	public void actionPerformed(ActionEvent e) {

		String name = JOptionPane.showInputDialog("Bitte Namen angeben");
		
		if(name != null) {
			
			if(name.length() == 0) {
				
				JOptionPane.showMessageDialog(null, "Der Name ist zu kurz");
				
			} else if(testsuite.existsTestsuite(name)) {
				
				JOptionPane.showMessageDialog(null, "Die Testsuite existiert bereits");
				
			} else {
				
				this.testsuiteController.createTestsuite(this.testsuite, name);
			}
		}
	}
}
